/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.Journeymap;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointEventManager;
import journeymap.common.waypoint.WaypointImpl;

@ParametersAreNonnullByDefault
public class WaypointStore {
    private static WaypointStore INSTANCE;
    private final Map<String, ClientWaypointImpl> waypointMap = new LinkedHashMap<String, ClientWaypointImpl>();
    private final Set<String> dimensions = new HashSet<String>();

    public static WaypointStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointStore();
        }
        return INSTANCE;
    }

    public List<ClientWaypointImpl> getAll(String modId) {
        if (modId != null) {
            return this.waypointMap.values().stream().filter(wp -> modId.equals(wp.getModId())).toList();
        }
        return null;
    }

    public List<ClientWaypointImpl> getAll() {
        return this.waypointMap.values().stream().toList();
    }

    public void save(ClientWaypointImpl waypoint, boolean isNew) {
        this.save(waypoint, true, isNew);
    }

    public void save(ClientWaypointImpl waypoint, boolean fireEvent, boolean isNew) {
        if (waypoint.isDirty()) {
            WaypointDAO dao = WaypointHandler.getInstance().getDao();
            this.waypointMap.put(waypoint.getGuid(), waypoint);
            if (fireEvent) {
                if (isNew) {
                    WaypointEventManager.createWaypointEvent(waypoint);
                } else {
                    WaypointEventManager.updateWaypointEvent(waypoint);
                }
            }
            if (waypoint.isPersistent()) {
                dao.addWaypoint(waypoint);
            }
            waypoint.setDirty(false);
            WaypointHandler.getInstance().getDao().save(true);
        }
    }

    public void bulkSave() {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        for (ClientWaypointImpl waypoint : this.waypointMap.values()) {
            WaypointEventManager.updateWaypointEvent(waypoint);
            if (!waypoint.isPersistent() || !waypoint.isDirty()) continue;
            waypoint.setDirty(false);
            dao.addWaypoint(waypoint);
        }
        dao.save(true);
    }

    public ClientWaypointImpl get(String id) {
        return this.waypointMap.get(id);
    }

    public void remove(ClientWaypointImpl waypoint, boolean fireEvent) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        this.waypointMap.remove(waypoint.getGuid());
        if (waypoint.isPersistent()) {
            if (fireEvent) {
                WaypointEventManager.deleteWaypointEvent(waypoint);
            }
            dao.deleteWaypoint(waypoint);
            dao.save(true);
        }
    }

    public void remove(WaypointGroup group) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        group.getWaypointIds().forEach(id -> {
            ClientWaypointImpl waypoint = this.get((String)id);
            this.waypointMap.remove(waypoint.getGuid());
            if (waypoint.isPersistent()) {
                WaypointEventManager.deleteWaypointEvent(waypoint);
                dao.deleteWaypoint(waypoint);
            }
        });
    }

    public void reset() {
        this.waypointMap.clear();
        this.dimensions.clear();
        if (JourneymapClient.getInstance().getWaypointProperties().managerEnabled.get().booleanValue()) {
            this.load();
        }
    }

    private void load() {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        Map<String, WaypointImpl> waypoints = dao.getWaypoints();
        Journeymap.getLogger().info("Loaded {} waypoints from disk.", (Object)waypoints.size());
        for (WaypointImpl waypoint : waypoints.values()) {
            this.waypointMap.put(waypoint.getGuid(), (ClientWaypointImpl)waypoint);
            WaypointEventManager.readWaypointEvent(waypoint);
            this.dimensions.addAll(waypoint.getDimensions());
        }
    }

    public List<String> getLoadedDimensions() {
        return new ArrayList<String>(this.dimensions);
    }
}

