/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import journeymap.client.JourneymapClientForge;
import journeymap.common.Journeymap;
import journeymap.common.config.ForgeConfig;
import journeymap.common.event.ForgeServerEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="journeymap")
@Mod.EventBusSubscriber(modid="journeymap")
public class JourneymapForge {
    private final Journeymap journeymap = new Journeymap();

    public JourneymapForge() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)new JourneymapClientForge()));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::serverStartingEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ForgeConfig.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverConfig);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imc);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "SERVER_ONLY", (remote, isServer) -> true));
    }

    private void imc(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"darkmodeeverywhere", (String)"dme-shaderblacklist", () -> "journeymap");
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeServerEvents());
    }

    @SubscribeEvent
    public void serverConfig(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            this.journeymap.setAdminConfig(new ForgeConfig());
        }
    }

    @SubscribeEvent
    public void serverStartingEvent(ServerStartingEvent event) {
        this.journeymap.serverStarted(event.getServer());
    }
}

