/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.OnOffButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.legacy.DimensionsDropDownButton;
import journeymap.client.ui.waypointmanager.legacy.SortButton;
import journeymap.client.ui.waypointmanager.legacy.WaypointManagerItem;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LegacyWaypointManager
extends JmUILegacy {
    static final String ASCEND = "\u25b2";
    static final String DESCEND = "\u25bc";
    static final int COLWAYPOINT = 0;
    static final int COLLOCATION = 20;
    static final int COLNAME = 60;
    static final int DEFAULT_ITEMWIDTH = 460;
    private static WaypointManagerItem.Sort currentSort;
    private final String on = Constants.getString("jm.common.on");
    private final String off = Constants.getString("jm.common.off");
    protected int colWaypoint = 0;
    protected int colLocation = 20;
    protected int colName = 60;
    protected int itemWidth = 460;
    protected ScrollListPane itemScrollPane;
    protected int rowHeight = 16;
    Boolean canUserTeleport;
    private SortButton buttonSortName;
    private SortButton buttonSortDistance;
    private SortButton buttonSortDeviation;
    private DimensionsDropDownButton buttonDimensions;
    private Button buttonClose;
    private Button buttonAdd;
    private Button buttonOptions;
    private OnOffButton buttonToggleAll;
    private ButtonList bottomButtons;
    private ClientWaypointImpl focusWaypoint;
    private ArrayList<WaypointManagerItem> items = new ArrayList();
    private static boolean toggled;

    public LegacyWaypointManager() {
        this((ClientWaypointImpl)null, (Screen)null);
    }

    public LegacyWaypointManager(Screen returnDisplay) {
        this((ClientWaypointImpl)null, returnDisplay);
    }

    public LegacyWaypointManager(ClientWaypointImpl focusWaypoint, Screen returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), returnDisplay);
        this.focusWaypoint = focusWaypoint;
    }

    public void setFocusWaypoint(ClientWaypointImpl focusWaypoint) {
        this.focusWaypoint = focusWaypoint;
    }

    @Override
    public void init() {
        try {
            this.setRenderBottomBar(true);
            this.getRenderables().clear();
            Journeymap.getLogger().debug("Checking if tp is permitted");
            this.canUserTeleport = CmdTeleportWaypoint.isPermitted(Minecraft.getInstance());
            Journeymap.getLogger().debug("Checked if tp button should be displayed:" + this.canUserTeleport);
            Font fr = this.getFontRenderer();
            WaypointManagerItem.DistanceComparator distanceSort = new WaypointManagerItem.DistanceComparator((Player)Minecraft.getInstance().player, true);
            String distanceLabel = Constants.getString("jm.waypoint.distance");
            this.buttonSortDistance = new SortButton(distanceLabel, distanceSort, b -> {
                this.buttonSortDistance.toggle();
                this.updateSort(this.buttonSortDistance);
            });
            this.buttonSortDistance.setTextOnly(fr);
            this.getRenderables().add((Renderable)this.buttonSortDistance);
            this.addRenderableWidget((GuiEventListener)this.buttonSortDistance);
            WaypointManagerItem.NameComparator nameSort = new WaypointManagerItem.NameComparator(true);
            WaypointManagerItem.DeviationComparator deviationSort = new WaypointManagerItem.DeviationComparator(true);
            this.buttonSortName = new SortButton(Constants.getString("jm.waypoint.name"), nameSort, b -> {
                this.buttonSortName.toggle();
                this.updateSort(this.buttonSortName);
            });
            this.buttonSortName.setTextOnly(fr);
            this.addRenderableWidget((GuiEventListener)this.buttonSortName);
            this.getRenderables().add((Renderable)this.buttonSortName);
            this.buttonSortDeviation = new SortButton(Constants.getString("jm.waypoint.deviation_button_sort"), deviationSort, b -> {
                this.buttonSortDeviation.toggle();
                this.updateSort(this.buttonSortDeviation);
            });
            this.buttonSortDeviation.setTextOnly(fr);
            this.addRenderableWidget((GuiEventListener)this.buttonSortDeviation);
            this.getRenderables().add((Renderable)this.buttonSortDeviation);
            String enableOn = Constants.getString("jm.waypoint.enable_all", "", this.on);
            String enableOff = Constants.getString("jm.waypoint.enable_all", "", this.off);
            this.buttonToggleAll = new OnOffButton(enableOff, enableOn, true, b -> {
                boolean state = this.buttonToggleAll.getToggled();
                state = this.toggleItems(state);
                this.buttonToggleAll.setToggled(state);
            });
            this.buttonToggleAll.setTextOnly(this.getFontRenderer());
            this.addRenderableWidget((GuiEventListener)this.buttonToggleAll);
            this.getRenderables().add((Renderable)this.buttonToggleAll);
            this.buttonDimensions = new DimensionsDropDownButton(b -> this.updateItems());
            this.addRenderableWidget((GuiEventListener)this.buttonDimensions);
            if (JourneymapClient.getInstance().getWaypointProperties().managerDimensionFocus.get().booleanValue()) {
                this.buttonDimensions.setDim((ResourceKey<Level>)this.minecraft.player.getCommandSenderWorld().dimension());
            }
            this.buttonAdd = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.waypoint.new"), button -> UIManager.INSTANCE.openWaypointEditor(null, false)));
            this.buttonAdd.fitWidth(this.getFontRenderer());
            this.buttonAdd.setWidth(this.buttonAdd.getWidth() * 2);
            this.buttonOptions = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager((Screen)this, ClientCategory.Waypoint, ClientCategory.WaypointBeacon)));
            this.buttonOptions.fitWidth(this.getFontRenderer());
            this.buttonClose = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.common.close"), button -> this.refreshAndClose()));
            this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonAdd, this.buttonDimensions, this.buttonClose);
            this.buttonOptions.setDefaultStyle(false);
            this.buttonAdd.setDefaultStyle(false);
            this.buttonDimensions.setDefaultStyle(false);
            this.buttonClose.setDefaultStyle(false);
            this.getRenderables().addAll(this.bottomButtons);
            SortButton sortButton = this.getInitialSort();
            currentSort = sortButton.sort;
            this.updateSort(sortButton);
            if (this.items.isEmpty()) {
                this.updateItems();
            }
            if (this.itemScrollPane == null) {
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.itemScrollPane = new ScrollListPane(this.minecraft, 0, 36, this.width, this.height - 36 - 30, 20);
            } else {
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.itemScrollPane.updateSize(this.width, this.height - 36 - 30, 0, 36);
                this.itemScrollPane.updateSlots();
            }
            this.itemScrollPane.setSlots(this.items);
            if (!this.items.isEmpty()) {
                this.itemScrollPane.scrollTo(this.items.get(0));
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.init(): " + String.valueOf(t), t);
        }
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics) {
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.init();
        }
        this.buttonToggleAll.setDrawButton(!this.items.isEmpty());
        this.buttonSortDistance.setDrawButton(!this.items.isEmpty());
        this.buttonSortName.setDrawButton(!this.items.isEmpty());
        this.buttonSortDeviation.setDrawButton(!this.items.isEmpty() && JourneymapClient.getInstance().getWaypointProperties().showDeviationLabel.get() != false);
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        int bottomButtonWidth = Math.min(this.bottomButtons.getWidth(4) + 25, this.itemScrollPane.getRowWidth());
        this.bottomButtons.equalizeWidths(this.getFontRenderer(), 4, bottomButtonWidth);
        this.bottomButtons.layoutCenteredHorizontal(this.width / 2, this.height - 25, true, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(GuiGraphics graphics, int x, int y, float par3) {
        if (this.minecraft == null) {
            return;
        }
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.init();
        }
        if (currentSort != null) {
            Collections.sort(this.items, currentSort);
        }
        if (this.itemScrollPane != null) {
            this.itemScrollPane.setSlots(this.items);
        }
        try {
            graphics.pose().pushPose();
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.itemScrollPane.updateSize(this.width, this.height - 36 - 30, 0, 36);
            List<FormattedCharSequence> lastTooltip = this.itemScrollPane.lastTooltip;
            long lastTooltipTime = this.itemScrollPane.lastTooltipTime;
            this.itemScrollPane.lastTooltip = null;
            this.itemScrollPane.render(graphics, x, y, par3);
            super.render(graphics, x, y, par3);
            if (!this.items.isEmpty()) {
                Objects.requireNonNull(this.getFontRenderer());
                int headerY = 36 - 9;
                WaypointManagerItem firstRow = this.items.get(0);
                if (firstRow.y > headerY + 16) {
                    headerY = firstRow.y - 16;
                }
                this.buttonToggleAll.centerHorizontalOn(firstRow.getButtonEnableCenterX()).setY(headerY);
                this.buttonSortDistance.centerHorizontalOn(firstRow.getLocationLeftX()).setY(headerY);
                this.colName = this.buttonSortDistance.getRightX() + 20;
                this.buttonSortName.setScrollablePosition(this.colName - 5, headerY);
                this.buttonSortDeviation.centerHorizontalOn(firstRow.getButtonDeviationX()).setY(headerY);
            }
            this.buttonToggleAll.drawUnderline(graphics);
            for (List<SlotMetadata> toolbar : this.getToolbars().values()) {
                for (SlotMetadata slotMetadata : toolbar) {
                    slotMetadata.getButton().secondaryDrawButton();
                }
            }
            if (this.itemScrollPane.lastTooltip != null && this.itemScrollPane.lastTooltip.equals(lastTooltip)) {
                this.itemScrollPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.itemScrollPane.lastTooltipTime > this.itemScrollPane.hoverDelay) {
                    Button button = this.itemScrollPane.lastTooltipMetadata.getButton();
                    graphics.renderTooltip(this.font, this.itemScrollPane.lastTooltip, x, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.render(): " + String.valueOf(t), t);
        }
        finally {
            graphics.pose().popPose();
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            boolean pressed;
            if (mouseButton == 0 && (pressed = this.itemScrollPane.mouseClicked(mouseX, mouseY, mouseButton))) {
                this.checkPressedButton();
                return true;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Problem with mouseClicked", (Throwable)e);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.itemScrollPane.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.checkPressedButton();
        this.itemScrollPane.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean mouseScrolled(double x, double y, double f, double scroll) {
        if (this.itemScrollPane.mouseScrolled(x, y, f, scroll)) {
            return true;
        }
        return super.mouseScrolled(x, y, f, scroll);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkPressedButton() {
        try {
            CategorySlot parentSlot;
            SlotMetadata slotMetadata = this.itemScrollPane.getLastPressed();
            if (slotMetadata != null) {
                // empty if block
            }
            if ((parentSlot = (CategorySlot)this.itemScrollPane.getLastPressedParentSlot()) == null) return;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("WARNING: Problem checking buttons.");
            throw new RuntimeException("checkPressedButton", e);
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (keyCode == 256) {
            this.closeAndReturn();
        }
        if (this.itemScrollPane != null) {
            boolean keyUsed = this.itemScrollPane.charTyped(typedChar, keyCode);
            if (keyUsed) {
                return true;
            }
            if (keyCode == 265) {
                this.itemScrollPane.scroll(-this.rowHeight);
                return true;
            }
            if (keyCode == 264) {
                this.itemScrollPane.scroll(this.rowHeight);
                return true;
            }
            if (keyCode == 266) {
                this.itemScrollPane.scroll(-this.itemScrollPane.getHeight());
                return true;
            }
            if (keyCode == 267) {
                this.itemScrollPane.scroll(this.itemScrollPane.getHeight());
                return true;
            }
            if (keyCode == 268) {
                this.itemScrollPane.scroll((int)(-this.itemScrollPane.getScrollAmount()));
                return true;
            }
            if (keyCode == 269) {
                this.itemScrollPane.scroll((int)this.itemScrollPane.getScrollAmount());
                return true;
            }
        } else {
            Journeymap.getLogger().error("WARNING: itemScrollPane is null. This is an error state! Report to Developers!");
        }
        return true;
    }

    protected boolean toggleItems(boolean enable) {
        for (WaypointManagerItem item : this.items) {
            if (enable != item.waypoint.isEnabled()) continue;
            enable = !enable;
            break;
        }
        for (WaypointManagerItem item : this.items) {
            if (item.waypoint.isEnabled() == enable) continue;
            item.enableWaypoint(enable);
        }
        return !enable;
    }

    public static void toggleWaypointRendering() {
        LegacyWaypointManager.renderWaypoints(JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get() == false);
    }

    public static void renderWaypoints(boolean value) {
        ChatLog.announceWaypointRendering(value);
        JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.set(value);
    }

    protected void updateItems() {
        this.items.clear();
        String currentDim = DimensionsDropDownButton.currentWorldProvider == null ? null : DimensionsDropDownButton.currentWorldProvider.getDimensionId();
        Font fr = this.getFontRenderer();
        List<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll();
        boolean allOn = true;
        this.itemWidth = 0;
        for (ClientWaypointImpl waypoint : waypoints) {
            WaypointManagerItem item = new WaypointManagerItem(waypoint, fr, this);
            this.itemWidth = Math.max(item.internalWidth, this.itemWidth);
            item.getDistanceTo((Player)this.minecraft.player);
            if (currentDim != null && !item.waypoint.getDimensions().contains(currentDim)) continue;
            this.items.add(item);
            if (!allOn) continue;
            allOn = waypoint.isEnabled();
        }
        if (this.items.isEmpty()) {
            this.itemWidth = 460;
        }
        this.buttonToggleAll.setToggled(!allOn);
        this.updateCount();
    }

    protected void updateSort(SortButton sortButton) {
        for (Renderable button : this.getRenderables()) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (!sortButton.sort.equals(currentSort)) {
                    sortButton.setActive(true);
                }
                this.updateSortProperty(sortButton);
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
    }

    protected void updateCount() {
        String itemCount = this.items.isEmpty() ? "" : Integer.toString(this.items.size());
        String enableOn = Constants.getString("jm.waypoint.enable_all", itemCount, this.on);
        String enableOff = Constants.getString("jm.waypoint.enable_all", itemCount, this.off);
        this.buttonToggleAll.setLabels(enableOff, enableOn);
    }

    protected boolean isSelected(WaypointManagerItem item) {
        return this.itemScrollPane.isSelectedItem(item.getSlotIndex());
    }

    protected int getMargin() {
        return this.width > this.itemWidth + 2 ? (this.width - this.itemWidth) / 2 : 0;
    }

    public void removeWaypoint(WaypointManagerItem item) {
        WaypointStore.getInstance().remove(item.waypoint, true);
        this.items.remove((Object)item);
        this.updateItems();
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        this.bottomButtons.setEnabled(false);
        WaypointGroupStore.getInstance().bulkSave();
        Fullscreen.state().requireRefresh();
        this.bottomButtons.setEnabled(true);
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    Map<Category, List<SlotMetadata>> getToolbars() {
        return Collections.EMPTY_MAP;
    }

    private SortButton getInitialSort() {
        WaypointProperties prop = JourneymapClient.getInstance().getWaypointProperties();
        boolean ascending = prop.sortAscending.get();
        SortButton button = switch ((WaypointManagerItem.SortType)((Object)prop.initialSortOrder.get())) {
            case WaypointManagerItem.SortType.Deviation -> this.buttonSortDeviation;
            case WaypointManagerItem.SortType.Name -> this.buttonSortName;
            default -> this.buttonSortDistance;
        };
        button.sort.ascending = ascending;
        button.setToggled(ascending);
        return button;
    }

    private void updateSortProperty(SortButton sortButton) {
        WaypointProperties prop = JourneymapClient.getInstance().getWaypointProperties();
        if (sortButton == this.buttonSortDistance) {
            prop.initialSortOrder.set(WaypointManagerItem.SortType.Distance);
        } else if (sortButton == this.buttonSortName) {
            prop.initialSortOrder.set(WaypointManagerItem.SortType.Name);
        } else if (sortButton == this.buttonSortDeviation) {
            prop.initialSortOrder.set(WaypointManagerItem.SortType.Deviation);
        }
        prop.sortAscending.set(sortButton.sort.ascending);
    }

    static {
        toggled = true;
    }
}

