/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class DeleteConfirmGroupPopup
extends PopupButtonScreen<Tuple2<Boolean, Boolean>> {
    private final LinearLayout layout = LinearLayout.vertical();
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.parse((String)"popup/background");
    private boolean deleteWaypoints = false;

    protected DeleteConfirmGroupPopup(WaypointGroup group) {
        super((Component)Component.translatable((String)"jm.waypoint.delete_group.title", (Object[])new Object[]{group.getName()}));
    }

    protected void init() {
        CheckBox checkbox = new CheckBox(Constants.getString("jm.waypoint.delete_group.confirm.checkbox."), false, button -> this.setDeleteWaypoints(((CheckBox)button).getToggled()));
        checkbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.delete_group.confirm.checkbox.tooltip", (Object[])new Object[]{WaypointGroupStore.DEFAULT.getName()})));
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(150).setCentered(true));
        this.layout.addChild((LayoutElement)checkbox);
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(6);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.delete"), b -> this.delete()).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> super.onClose()).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    @Override
    public void renderPopupScreenBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    private void delete() {
        this.setResponseAndClose(new Tuple2((Object)true, (Object)this.deleteWaypoints));
    }

    private void setDeleteWaypoints(boolean deleteWaypoints) {
        this.deleteWaypoints = deleteWaypoints;
    }

    @Override
    protected void onClosed() {
        this.onClose.closed((Tuple2)this.response);
        super.onClose();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }
}

