/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import journeymap.api.v2.common.event.CommonEventRegistry;
import journeymap.api.v2.common.event.common.WaypointEvent;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.ClientCategory;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.SortButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.popupscreenbutton.ImagePopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.waypointmanager.DimensionsDropDownButton;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.client.ui.waypointmanager.group.GroupPanel;
import journeymap.client.ui.waypointmanager.group.GroupSettingsPopup;
import journeymap.client.ui.waypointmanager.group.GroupSlot;
import journeymap.client.ui.waypointmanager.waypoint.WaypointEditor;
import journeymap.client.ui.waypointmanager.waypoint.WaypointPanel;
import journeymap.client.ui.waypointmanager.waypoint.WaypointSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.JM;
import journeymap.common.mixin.client.ScreenAccessor;
import journeymap.common.waypoint.GroupSettings;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;

public class WaypointManager
extends JmUI {
    private final ClientWaypointImpl focusWaypoint;
    private Map<WaypointGroup, GroupSlot> groupMap;
    private GroupPanel<GroupSlot> groupPanel;
    private final WaypointGroup allGroup = WaypointGroupStore.getInstance().get(WaypointGroupStore.ALL.getGuid());
    private static WaypointGroup selectedGroup = WaypointGroupStore.getInstance().get(WaypointGroupStore.ALL.getGuid());
    private String lastSelectedGroup;
    private LinearLayout groupHeaderLayout;
    private LinearLayout groupSortLayout;
    private LinearLayout waypointSortLayout;
    private LinearLayout waypointHeaderLayout;
    private LinearLayout headerLayouts;
    private final Map<WaypointGroup, WaypointPanel<WaypointSlot>> panelMap = new HashMap<WaypointGroup, WaypointPanel<WaypointSlot>>();
    private DimensionsDropDownButton dimButton;
    private Button createGroupButton;
    private SortButton groupCountSortButton;
    private SortButton groupNameSortButton;
    private SortButton waypointDistanceSortButton;
    private SortButton waypointNameSortButton;
    private SearchTextBox searchTextBox;
    private int sidePanelSize = 120;
    private int panelYOffset = 40;

    public WaypointManager(Screen returnDisplay) {
        this(null, returnDisplay);
    }

    public WaypointManager(ClientWaypointImpl focusWaypoint, Screen returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), true, returnDisplay);
        this.minecraft = Minecraft.getInstance();
        this.focusWaypoint = focusWaypoint;
        this.groupMap = this.buildGroupSlots();
        CommonEventRegistry.WAYPOINT_GROUP_EVENT.subscribe((Object)this, JM.MOD_ID, this::onWaypointGroupEvent);
        CommonEventRegistry.WAYPOINT_EVENT.subscribe((Object)this, JM.MOD_ID, this::onWaypointEvent);
    }

    private void onWaypointGroupEvent(WaypointGroupEvent event) {
        if (!event.isCancelled()) {
            switch (event.getContext()) {
                case DELETED: {
                    WaypointGroupStore.getInstance().remove(event.getGroup(), event.deleteWaypoints());
                    GroupSlot defaultGroup = this.groupMap.get(WaypointGroupStore.getInstance().get(WaypointGroupStore.DEFAULT.getGuid()));
                    GroupSlot group = this.groupMap.getOrDefault(this.allGroup, defaultGroup);
                    this.updateSelectedGroup(group);
                    this.updateDimButton(group);
                    this.redrawSelectedWaypointSlots(group.getGroup());
                    this.updateGroupSlots();
                    break;
                }
                case UPDATE: 
                case CREATE: {
                    this.addNewGroup(event.getGroup());
                }
            }
        }
    }

    private void onWaypointEvent(WaypointEvent event) {
        switch (event.getContext()) {
            case DELETED: {
                WaypointStore.getInstance().remove((ClientWaypointImpl)event.getWaypoint(), false);
                break;
            }
            case UPDATE: 
            case CREATE: {
                if (event.isCancelled()) break;
                WaypointStore.getInstance().save((ClientWaypointImpl)event.getWaypoint(), false, event.getContext() == WaypointEvent.Context.CREATE);
            }
        }
        this.updateGroupSlots();
        this.redrawSelectedWaypointSlots(selectedGroup);
    }

    @Override
    public void init() {
        super.init();
        Font font = Minecraft.getInstance().font;
        this.groupHeaderLayout = LinearLayout.horizontal();
        this.groupSortLayout = LinearLayout.horizontal();
        this.waypointHeaderLayout = LinearLayout.horizontal();
        this.waypointHeaderLayout.spacing(5);
        this.groupHeaderLayout.spacing(2);
        this.groupSortLayout.spacing(2);
        this.waypointSortLayout = LinearLayout.horizontal();
        this.headerLayouts = LinearLayout.horizontal();
        this.headerLayouts.addChild((LayoutElement)this.groupHeaderLayout, LayoutSettings::alignVerticallyMiddle);
        this.headerLayouts.addChild((LayoutElement)this.waypointHeaderLayout);
        this.contentLayout.addChild((LayoutElement)this.headerLayouts);
        this.contentLayout.addChild((LayoutElement)this.groupSortLayout);
        this.contentLayout.addChild((LayoutElement)this.waypointSortLayout);
        this.waypointSortLayout.spacing(12);
        try {
            this.footerLayout.addChild((LayoutElement)net.minecraft.client.gui.components.Button.builder((Component)Component.translatable((String)"jm.common.close"), b -> this.closeAndReturn()).width(20 + font.width((FormattedText)Component.translatable((String)"jm.common.close"))).build());
            this.groupPanel = new GroupPanel(this.minecraft, this, 1, 36 + this.panelYOffset + 15, this.sidePanelSize - 1, this.height - 66 - 25, 20);
            this.groupPanel.setSlots(this.groupMap.values().stream().toList());
            this.groupPanel.initSlots();
            this.dimButton = new DimensionsDropDownButton(this::updateDimFilter);
            this.dimButton.setDefaultStyle(false);
            this.dimButton.setDrawBackground(false);
            this.dimButton.setHeight(15);
            this.dimButton.setRenderSolidBackground(true);
            this.groupSortLayout.addChild((LayoutElement)new SpacerElement(20, 12));
            this.groupNameSortButton = (SortButton)this.groupSortLayout.addChild((LayoutElement)new SortButton(Constants.getString("jm.waypoint.name"), "name", this.getGroupSortDir("name"), this::groupSort));
            this.groupSortLayout.addChild((LayoutElement)new SpacerElement(0, 12));
            this.groupCountSortButton = (SortButton)this.groupSortLayout.addChild((LayoutElement)new SortButton(Constants.getString("jm.waypoint.count"), "count", this.getGroupSortDir("count"), this::groupSort));
            this.waypointDistanceSortButton = (SortButton)this.waypointSortLayout.addChild((LayoutElement)new SortButton(Constants.getString("jm.waypoint.distance"), "dist", this.getWaypointSortDir("dist"), this::waypointSort));
            this.waypointNameSortButton = (SortButton)this.waypointSortLayout.addChild((LayoutElement)new SortButton(Constants.getString("jm.waypoint.name"), "name", this.getWaypointSortDir("name"), this::waypointSort));
            this.groupHeaderLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.groups"), font), LayoutSettings::alignVerticallyMiddle);
            ((ImagePopupButton)this.groupHeaderLayout.addChild(new ImagePopupButton<Boolean>(12, 12, TextureCache.OPTIONS_SPRITE, Constants.getString("jm.waypoint.group.edit_settings.title"), GroupSettingsPopup::new, this::onGroupSettings))).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.title")));
            this.createGroupButton = (Button)this.groupHeaderLayout.addChild(new PopupButton<WaypointGroup>(0, 0, "+", () -> new EditGroupPopup((Component)Component.translatable((String)"jm.waypoint.group.new_group.label")), this::addNewGroup), LayoutSettings::alignVerticallyMiddle);
            this.createGroupButton.setMessage((Component)Component.literal((String)"+").withStyle(ChatFormatting.DARK_GREEN));
            this.createGroupButton.setSize(12, 12);
            this.createGroupButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.new_group.label")));
            this.waypointHeaderLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.waypoints"), font), LayoutSettings::alignVerticallyMiddle);
            this.searchTextBox = (SearchTextBox)this.waypointHeaderLayout.addChild((LayoutElement)new SearchTextBox("", font, 70, 15), LayoutSettings::alignVerticallyMiddle);
            this.waypointHeaderLayout.addChild((LayoutElement)this.dimButton);
            PopupButton createWaypoint = (PopupButton)this.waypointHeaderLayout.addChild(new PopupButton<Waypoint>(0, 0, "+", () -> new WaypointEditor(false, null, selectedGroup), wp -> {}), LayoutSettings::alignVerticallyMiddle);
            createWaypoint.setMessage((Component)Component.literal((String)"+").withStyle(ChatFormatting.DARK_GREEN));
            createWaypoint.setSize(12, 12);
            createWaypoint.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.new_title")));
            ((BasicImageButton)this.waypointHeaderLayout.addChild((LayoutElement)new BasicImageButton(12, 12, TextureCache.OPTIONS_SPRITE, this::openWaypointOptions, (Component)Component.translatable((String)"jm.waypoint.options.tooltip")), LayoutSettings::alignVerticallyMiddle)).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.options.tooltip")));
            this.searchTextBox.setBordered(false);
            this.searchTextBox.setFillColor(0, 0.4f);
            this.searchTextBox.setResponder(this::updateSearch);
            this.addRenderableWidget((GuiEventListener)this.groupPanel);
            this.groupPanel.visitSlots(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
            });
            this.addRenderableWidget((GuiEventListener)this.getWaypointPanel(selectedGroup));
            this.getWaypointPanel(selectedGroup).initSlots();
            this.getWaypointPanel(selectedGroup).visitSlots(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
            });
            this.groupPanel.setSelected(WaypointGroupStore.getDisplaySetting("last_selected", this.allGroup.getGuid()));
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in WaypointManager.init(): {}", t);
        }
    }

    private void openWaypointOptions(net.minecraft.client.gui.components.Button button) {
        ((ScreenAccessor)((Object)this)).setInitialized(false);
        UIManager.INSTANCE.openOptionsManager((Screen)this, ClientCategory.Waypoint, ClientCategory.WaypointBeacon);
    }

    private void waypointSort(net.minecraft.client.gui.components.Button button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        String dir = sortButton.getToggled() != false ? "asc" : "desc";
        WaypointGroupImpl group = (WaypointGroupImpl)selectedGroup;
        group.getSettings().setDisplaySetting("wp_sort", sortButton.getKey());
        group.getSettings().setDisplaySetting("wp_sort_type", dir);
        if ("name".equals(sortButton.getKey())) {
            this.waypointDistanceSortButton.setSorting(false);
            this.waypointNameSortButton.setSorting(true);
        } else {
            this.waypointNameSortButton.setSorting(false);
            this.waypointDistanceSortButton.setSorting(true);
        }
        this.redrawSelectedWaypointSlots(selectedGroup);
    }

    private void groupSort(net.minecraft.client.gui.components.Button button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        String dir = sortButton.getToggled() != false ? "asc" : "desc";
        WaypointGroupStore.setDisplaySetting("sort", sortButton.getKey());
        WaypointGroupStore.setDisplaySetting("sort_type", dir);
        if ("name".equals(sortButton.getKey())) {
            this.groupCountSortButton.setSorting(false);
            this.groupNameSortButton.setSorting(true);
        } else {
            this.groupNameSortButton.setSorting(false);
            this.groupCountSortButton.setSorting(true);
        }
        this.updateGroupSlots();
    }

    private void updateSearch(String text) {
        this.redrawSelectedWaypointSlots(selectedGroup);
    }

    @Override
    protected void repositionElements() {
        super.repositionElements();
        this.headerLayouts.setPosition(5, 39);
        this.waypointHeaderLayout.setX(this.sidePanelSize + 5);
        this.groupSortLayout.setPosition(5, 59);
        this.waypointSortLayout.setPosition(this.sidePanelSize + 5, 59);
        this.groupPanel.updateSize(this.sidePanelSize - 1, this.height - 66 - this.panelYOffset, 1, 36 + this.panelYOffset);
        this.groupPanel.updateSlots();
        this.groupPanel.setScrollAmount(0.0);
        this.groupPanel.repositionSlots();
        this.getWaypointPanel(selectedGroup).repositionSlots();
        this.panelMap.forEach((group, pane) -> {
            pane.updateSize(this.width - this.sidePanelSize - 4, this.height - 66 - this.panelYOffset, this.sidePanelSize + 2, 36 + this.panelYOffset);
            pane.updateSlots();
            pane.setScrollAmount(0.0);
            pane.repositionSlots();
        });
        this.groupCountSortButton.setSorting("name".equals(WaypointGroupStore.getDisplaySetting("sort", "name")));
        this.groupNameSortButton.setSorting("count".equals(WaypointGroupStore.getDisplaySetting("sort", "name")));
        this.waypointDistanceSortButton.setSorting("dist".equals(((WaypointGroupImpl)selectedGroup).getSettings().getDisplaySetting("wp_sort", "name")));
        this.waypointNameSortButton.setSorting("name".equals(((WaypointGroupImpl)selectedGroup).getSettings().getDisplaySetting("wp_sort", "name")));
        this.updateDimButton(this.groupPanel.getSelected() == null ? this.groupMap.get(this.allGroup) : (GroupSlot)this.groupPanel.getSelected());
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float par3) {
        GroupPanel<GroupSlot> panelUnderMouse;
        GroupSlot groupSlot;
        WaypointGroup group;
        super.render(graphics, x, y, par3);
        this.outline(graphics, 0, 36, this.width - 1, this.height - 66);
        DrawUtil.drawRectangle(graphics, this.sidePanelSize, 36.0, 1.0, this.height - 66, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 56.0, this.width - 1, 1.0, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 71.0, this.width - 1, 1.0, 0xC0C0C0, 0.8f);
        Optional child = this.groupPanel.getChildAt(x, y);
        if (this.getWaypointPanel(selectedGroup).getDraggingSlot() != null && child.isPresent() && (group = (groupSlot = (GroupSlot)child.get()).getGroup()) != null) {
            boolean transferable = WaypointGroupStore.getInstance().canTransferWaypoint(group, this.getWaypointPanel(selectedGroup).getDraggingSlot().getWaypoint());
            groupSlot.renderTransferStatus(graphics, transferable);
        }
        ScrollListPane scrollListPane = child.isPresent() ? this.groupPanel : (panelUnderMouse = this.getWaypointPanel(selectedGroup).getChildAt(x, y).isPresent() ? this.getWaypointPanel(selectedGroup) : null);
        if (panelUnderMouse != null) {
            List<FormattedCharSequence> lastTooltip = panelUnderMouse.lastTooltip;
            long lastTooltipTime = panelUnderMouse.lastTooltipTime;
            if (panelUnderMouse.lastTooltip != null && panelUnderMouse.lastTooltip.equals(lastTooltip)) {
                panelUnderMouse.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - panelUnderMouse.lastTooltipTime > panelUnderMouse.hoverDelay) {
                    graphics.renderTooltip(this.font, panelUnderMouse.lastTooltip, x, y + 15);
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (button == 0) {
            Slot groupSelected = (Slot)this.groupPanel.getSelected();
            if (groupSelected != null && this.groupPanel.isMouseOver(mouseX, mouseY)) {
                this.updateSelectedGroup(groupSelected);
                this.updateDimButton((GroupSlot)groupSelected);
                this.redrawSelectedWaypointSlots(((GroupSlot)groupSelected).getGroup());
                WaypointGroupStore.setDisplaySetting("last_selected", ((GroupSlot)groupSelected).getGroup().getGuid());
            }
            Slot slot = (Slot)this.getWaypointPanel(selectedGroup).getSelected();
        }
        return clicked;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean didTransfer = false;
        Optional child = this.groupPanel.getChildAt(mouseX, mouseY);
        if (this.getWaypointPanel(selectedGroup).getDraggingSlot() != null && child.isPresent()) {
            WaypointGroup groupTo = ((GroupSlot)child.get()).getGroup();
            Waypoint waypoint = this.getWaypointPanel(selectedGroup).getDraggingSlot().getWaypoint();
            WaypointGroupImpl groupFrom = WaypointGroupStore.getInstance().get(waypoint.getGroupId());
            didTransfer = groupTo.addWaypoint(waypoint);
            if (didTransfer) {
                this.updateGroupSlots();
                if (!this.allGroup.getGuid().equals(selectedGroup.getGuid())) {
                    this.redrawSelectedWaypointSlots(groupFrom);
                }
            }
        }
        boolean groupMouseReleased = this.groupPanel.mouseReleased(mouseX, mouseY, button);
        if (this.lastSelectedGroup != null) {
            this.groupPanel.select(this.lastSelectedGroup);
        }
        boolean waypointsMouseReleased = this.getWaypointPanel(selectedGroup).mouseReleased(mouseX, mouseY, button);
        return groupMouseReleased || waypointsMouseReleased;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.groupPanel.mouseDragged(mouseX, mouseY, button, dragX, dragY) || this.getWaypointPanel(selectedGroup).mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean groupScrolled = false;
        boolean waypointsScrolled = false;
        WaypointPanel<WaypointSlot> waypointPanel = this.getWaypointPanel(selectedGroup);
        if (this.groupPanel.isMouseOver(mouseX, mouseY)) {
            groupScrolled = this.groupPanel.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        } else if (waypointPanel.isMouseOver(mouseX, mouseY)) {
            waypointsScrolled = this.getWaypointPanel(selectedGroup).mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return groupScrolled || waypointsScrolled;
    }

    public void updateSelectedGroup(Slot groupSelected) {
        this.lastSelectedGroup = ((GroupSlot)groupSelected).getGroup().getGuid();
        this.getWaypointPanel(selectedGroup).visitSlots(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.groupPanel.unselect();
        this.removeWidget((GuiEventListener)this.getWaypointPanel(selectedGroup));
        selectedGroup = ((GroupSlot)groupSelected).getGroup();
        this.getWaypointPanel(selectedGroup).setSlots(this.getWaypointsForGroup(selectedGroup));
        this.addRenderableWidget((GuiEventListener)this.getWaypointPanel(selectedGroup));
        this.getWaypointPanel(selectedGroup).initSlots();
        this.getWaypointPanel(selectedGroup).visitSlots(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.groupPanel.select(this.lastSelectedGroup);
    }

    private void updateDimFilter(net.minecraft.client.gui.components.Button button) {
        WorldData.DimensionProvider selected = (WorldData.DimensionProvider)((DropDownItem)button).getId();
        String value = selected == null ? "all" : selected.getDimensionId();
        GroupSettings groupSettings = ((WaypointGroupImpl)selectedGroup).getSettings();
        String dimDisplay = groupSettings.getDisplaySettings().get("dimDisplay");
        if (dimDisplay == null || !dimDisplay.equals(value)) {
            groupSettings.setDisplaySetting("dimDisplay", value);
            WaypointGroupStore.getInstance().put(selectedGroup);
        }
        this.redrawSelectedWaypointSlots(selectedGroup);
    }

    private void updateDimButton(GroupSlot groupSlot) {
        String displayDim;
        WaypointGroup group = this.allGroup;
        if (groupSlot != null) {
            group = groupSlot.getGroup();
        }
        this.dimButton.setDim((displayDim = ((WaypointGroupImpl)group).getSettings().getDisplaySettings().get("dimDisplay")) == null || "all".equals(displayDim) ? null : displayDim);
    }

    protected Map<WaypointGroup, GroupSlot> buildGroupSlots() {
        WaypointGroupStore store = WaypointGroupStore.getInstance();
        LinkedHashMap<WaypointGroup, GroupSlot> map = new LinkedHashMap<WaypointGroup, GroupSlot>();
        boolean hideEmpty = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_empty", "false"));
        boolean hideAll = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_all", "false"));
        boolean hideEmptyDeath = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_empty_death", "false"));
        boolean hideEmptyTemp = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_empty_temp", "false"));
        List<WaypointGroup> sortedGroups = this.sortGroups(store.getAll());
        if (!hideAll) {
            map.put(store.get(this.allGroup.getGuid()), new GroupSlot(store.get(this.allGroup.getGuid()), this.width, this.height));
        }
        map.put(store.get(WaypointGroupStore.DEFAULT.getGuid()), new GroupSlot(store.get(WaypointGroupStore.DEFAULT.getGuid()), this.width, this.height));
        if (!(hideEmptyDeath && store.get(WaypointGroupStore.DEATH.getGuid()).getWaypointIds().isEmpty() || !JourneymapClient.getInstance().getStateHandler().isAllowDeathPoints())) {
            map.put(store.get(WaypointGroupStore.DEATH.getGuid()), new GroupSlot(store.get(WaypointGroupStore.DEATH.getGuid()), this.width, this.height));
        }
        if (!hideEmptyTemp || !store.get(WaypointGroupStore.TEMP.getGuid()).getWaypointIds().isEmpty()) {
            map.put(store.get(WaypointGroupStore.TEMP.getGuid()), new GroupSlot(store.get(WaypointGroupStore.TEMP.getGuid()), this.width, this.height));
        }
        sortedGroups.forEach(group -> {
            if (!(map.containsKey(group) || hideEmpty && group.getWaypointIds().isEmpty() || this.isNativeGroup((WaypointGroup)group))) {
                map.put((WaypointGroup)group, new GroupSlot((WaypointGroup)group, this.width, this.height));
            }
        });
        WaypointGroupStore.getInstance().bulkSave();
        return map;
    }

    private boolean isNativeGroup(WaypointGroup group) {
        return group.getGuid().equals(WaypointGroupStore.TEMP.getGuid()) || group.getGuid().equals(WaypointGroupStore.DEATH.getGuid()) || group.getGuid().equals(WaypointGroupStore.DEFAULT.getGuid()) || group.getGuid().equals(WaypointGroupStore.ALL.getGuid());
    }

    protected List<WaypointSlot> getWaypointsForGroup(WaypointGroup group) {
        String dim = ((WaypointGroupImpl)group).getSettings().getDisplaySetting("dimDisplay", "all");
        List<WaypointSlot> slots = "all".equals(dim) || dim == null ? group.getWaypointIds().stream().map(id -> WaypointStore.getInstance().get((String)id)).toList().stream().map(WaypointSlot::new).toList() : group.getWaypointIds().stream().map(id -> WaypointStore.getInstance().get((String)id)).toList().stream().filter(wp -> wp.getDimensions().contains(dim)).toList().stream().map(WaypointSlot::new).toList();
        if (!StringUtil.isNullOrEmpty((String)this.searchTextBox.getValue())) {
            slots = slots.stream().filter(slot -> slot.getWaypoint().getName().toLowerCase().contains(this.searchTextBox.getValue().toLowerCase())).toList();
        }
        return this.sortedWaypoints(slots);
    }

    private void addNewGroup(WaypointGroup group) {
        if (group != null) {
            WaypointGroupStore.getInstance().put(group);
            this.updateGroupSlots();
            this.redrawSelectedWaypointSlots(selectedGroup);
        }
    }

    public void updateGroupSlots() {
        this.groupMap = this.buildGroupSlots();
        this.groupPanel.visitSlots(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.groupPanel.setSlots(this.groupMap.values().stream().toList());
        this.groupPanel.initSlots();
        this.groupPanel.visitSlots(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        if (this.lastSelectedGroup != null) {
            boolean hideall = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_all", "false"));
            this.groupPanel.select(this.lastSelectedGroup.equals(this.allGroup.getGuid()) && hideall ? WaypointGroupStore.DEFAULT.getGuid() : this.lastSelectedGroup);
        }
    }

    private List<WaypointSlot> sortedWaypoints(List<WaypointSlot> list) {
        WaypointGroupImpl group = (WaypointGroupImpl)selectedGroup;
        String sort = group.getSettings().getDisplaySetting("wp_sort", "name");
        String sortDir = group.getSettings().getDisplaySetting("wp_sort_type", "asc");
        Comparator<WaypointSlot> comparator = switch (sort) {
            case "dist" -> Comparator.comparingInt(WaypointSlot::getDistance);
            default -> Comparator.comparing(g -> g.getWaypoint().getName().toLowerCase());
        };
        ArrayList<WaypointSlot> sorted = new ArrayList<WaypointSlot>(list);
        if (sortDir.equals("desc")) {
            sorted.sort(comparator.reversed());
        } else {
            sorted.sort(comparator);
        }
        return sorted;
    }

    private List<WaypointGroup> sortGroups(List<WaypointGroup> list) {
        String sort = WaypointGroupStore.getDisplaySetting("sort", "name");
        String sortDir = WaypointGroupStore.getDisplaySetting("sort_type", "asc");
        Comparator<WaypointGroup> comparator = switch (sort) {
            case "count" -> Comparator.comparingInt(g -> ((WaypointGroupImpl)g).count());
            default -> Comparator.comparing(g -> g.getName().toLowerCase());
        };
        ArrayList<WaypointGroup> sorted = new ArrayList<WaypointGroup>(list);
        if (sortDir.equals("desc")) {
            sorted.sort(comparator.reversed());
        } else {
            sorted.sort(comparator);
        }
        return sorted;
    }

    private boolean getGroupSortDir(String value) {
        String sort = WaypointGroupStore.getDisplaySetting("sort", "name");
        if (sort.equals(value)) {
            String sortDir = WaypointGroupStore.getDisplaySetting("sort_type", "asc");
            return sortDir.equals("asc");
        }
        return true;
    }

    private boolean getWaypointSortDir(String value) {
        WaypointGroupImpl group = (WaypointGroupImpl)selectedGroup;
        String sort = group.getSettings().getDisplaySetting("wp_sort", "name");
        if (sort.equals(value)) {
            String sortDir = group.getSettings().getDisplaySetting("wp_sort_type", "asc");
            return sortDir.equals("asc");
        }
        return true;
    }

    private void redrawSelectedWaypointSlots(WaypointGroup group) {
        this.getWaypointPanel(selectedGroup).visitSlots(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.getWaypointPanel(selectedGroup).setSlots(this.getWaypointsForGroup(group));
        this.getWaypointPanel(selectedGroup).initSlots();
        this.getWaypointPanel(selectedGroup).visitSlots(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.getWaypointPanel(selectedGroup).updateSize(this.width - this.sidePanelSize - 4, this.height - 66 - this.panelYOffset, this.sidePanelSize + 2, 36 + this.panelYOffset);
        this.getWaypointPanel(selectedGroup).updateSlots();
        this.getWaypointPanel(selectedGroup).repositionSlots();
    }

    private WaypointPanel<WaypointSlot> getWaypointPanel(WaypointGroup group) {
        WaypointPanel<WaypointSlot> panel = this.panelMap.get(group);
        if (panel == null) {
            panel = new WaypointPanel(this.minecraft, this.sidePanelSize + 4, 36 + this.panelYOffset, this.width - this.sidePanelSize - 1, this.height - 66 - 25, 20);
            panel.setSlots(this.getWaypointsForGroup(group));
            this.panelMap.put(group, panel);
        }
        return panel;
    }

    public boolean isSearchFocused() {
        return this.searchTextBox.isFocused();
    }

    public void onClose() {
        WaypointStore.getInstance().bulkSave();
        WaypointGroupStore.getInstance().bulkSave();
        CommonEventRegistry.WAYPOINT_GROUP_EVENT.unsubscribe((Object)this, JM.MOD_ID);
        CommonEventRegistry.WAYPOINT_EVENT.unsubscribe((Object)this, JM.MOD_ID);
        super.onClose();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            this.onClose();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    private void onGroupSettings(boolean edited) {
        if (edited) {
            this.updateGroupSlots();
        }
    }
}

