/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import java.awt.geom.Point2D;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.ui.theme.Theme;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ThemeCompassPoints {
    final MutableComponent textNorth = Component.translatable((String)"jm.minimap.compass.n");
    final MutableComponent textSouth = Component.translatable((String)"jm.minimap.compass.s");
    final MutableComponent textEast = Component.translatable((String)"jm.minimap.compass.e");
    final MutableComponent textWest = Component.translatable((String)"jm.minimap.compass.w");
    final Point2D pointNorth;
    final Point2D pointSouth;
    final Point2D pointWest;
    final Point2D pointEast;
    final boolean showNorth;
    final boolean showSouth;
    final boolean showEast;
    final boolean showWest;
    final float fontScale;
    final float compassLabelHeight;
    final Theme.LabelSpec compassLabel;
    final Theme.ColorSpec compassPoint;
    final Texture compassPointTex;
    final int xOffset;
    final int yOffset;
    final double shiftVert;
    final double shiftHorz;
    final int labelShiftVert;
    private double x;
    private double y;

    public ThemeCompassPoints(int x, int y, int halfWidth, int halfHeight, Theme.Minimap.MinimapSpec minimapSpec, MiniMapProperties miniMapProperties, Texture compassPointTex, float labelHeight) {
        this.x = x;
        this.y = y;
        this.pointNorth = new Point2D.Double(x + halfWidth, y);
        this.pointSouth = new Point2D.Double(x + halfWidth, y + halfHeight + halfHeight);
        this.pointWest = new Point2D.Double(x, y + halfHeight);
        this.pointEast = new Point2D.Double(x + halfWidth + halfWidth, y + halfHeight);
        this.fontScale = miniMapProperties.compassFontScale.get().floatValue();
        this.compassLabelHeight = labelHeight;
        this.compassLabel = minimapSpec.compassLabel;
        this.compassPoint = minimapSpec.compassPoint;
        this.compassPointTex = compassPointTex;
        if (this.compassPointTex != null) {
            this.shiftVert = minimapSpec.compassPointOffset * (double)this.fontScale;
            this.shiftHorz = minimapSpec.compassPointOffset * (double)this.fontScale;
            this.pointNorth.setLocation(this.pointNorth.getX(), this.pointNorth.getY() - this.shiftVert);
            this.pointSouth.setLocation(this.pointSouth.getX(), this.pointSouth.getY() + this.shiftVert);
            this.pointWest.setLocation(this.pointWest.getX() - this.shiftHorz, this.pointWest.getY());
            this.pointEast.setLocation(this.pointEast.getX() + this.shiftHorz, this.pointEast.getY());
            this.xOffset = (int)((float)compassPointTex.getWidth() * this.fontScale / 2.0f);
            this.yOffset = (int)((float)compassPointTex.getHeight() * this.fontScale / 2.0f);
        } else {
            this.xOffset = 0;
            this.yOffset = 0;
            this.shiftHorz = 0.0;
            this.shiftVert = 0.0;
        }
        this.labelShiftVert = 0;
        this.showNorth = minimapSpec.compassShowNorth;
        this.showSouth = minimapSpec.compassShowSouth;
        this.showEast = minimapSpec.compassShowEast;
        this.showWest = minimapSpec.compassShowWest;
    }

    public static float getCompassPointScale(float compassLabelHeight, Theme.Minimap.MinimapSpec minimapSpec, Texture compassPointTex) {
        return (compassLabelHeight + (float)minimapSpec.compassPointLabelPad) / ((float)compassPointTex.getHeight() * 1.0f);
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void drawPoints(GuiGraphics graphics, double rotation) {
        if (this.compassPointTex != null) {
            int color = this.compassPoint.getColor();
            float alpha = this.compassPoint.alpha;
            if (this.showNorth) {
                DrawUtil.drawColoredImage(graphics.pose(), this.compassPointTex, color, alpha, this.pointNorth.getX() - (double)this.xOffset, this.pointNorth.getY() - (double)this.yOffset, this.fontScale, 0.0);
            }
            if (this.showSouth) {
                DrawUtil.drawColoredImage(graphics.pose(), this.compassPointTex, color, alpha, this.pointSouth.getX() - (double)this.xOffset, this.pointSouth.getY() - (double)this.yOffset, this.fontScale, 180.0);
            }
            if (this.showWest) {
                DrawUtil.drawColoredImage(graphics.pose(), this.compassPointTex, color, alpha, this.pointWest.getX() - (double)this.xOffset, this.pointWest.getY() - (double)this.yOffset, this.fontScale, -90.0);
            }
            if (this.showEast) {
                DrawUtil.drawColoredImage(graphics.pose(), this.compassPointTex, color, alpha, this.pointEast.getX() - (double)this.xOffset, this.pointEast.getY() - (double)this.yOffset, this.fontScale, 90.0);
            }
        }
    }

    public void drawLabels(GuiGraphics graphics, MultiBufferSource buffers, double rotation) {
        Theme.LabelSpec labelSpec = this.compassLabel;
        if (this.showNorth) {
            DrawUtil.drawBatchLabel(graphics.pose(), (Component)this.textNorth, DrawStep.Pass.Text, buffers, this.pointNorth.getX(), this.pointNorth.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, (double)this.fontScale, labelSpec.shadow, rotation);
        }
        if (this.showSouth) {
            DrawUtil.drawBatchLabel(graphics.pose(), (Component)this.textSouth, DrawStep.Pass.Text, buffers, this.pointSouth.getX(), this.pointSouth.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, (double)this.fontScale, labelSpec.shadow, rotation);
        }
        if (this.showWest) {
            DrawUtil.drawBatchLabel(graphics.pose(), (Component)this.textWest, DrawStep.Pass.Text, buffers, this.pointWest.getX(), this.pointWest.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, (double)this.fontScale, labelSpec.shadow, rotation);
        }
        if (this.showEast) {
            DrawUtil.drawBatchLabel(graphics.pose(), (Component)this.textEast, DrawStep.Pass.Text, buffers, this.pointEast.getX(), this.pointEast.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, (double)this.fontScale, labelSpec.shadow, rotation);
        }
    }
}

