/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import java.util.List;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.buttons.BooleanPropertyButton;
import journeymap.client.ui.theme.Theme;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ThemeButton
extends BooleanPropertyButton
implements IThemeButton {
    protected Theme theme;
    protected Theme.Control.ButtonSpec buttonSpec;
    protected Texture textureOn;
    protected Texture textureHover;
    protected Texture textureOff;
    protected Texture textureDisabled;
    protected Texture textureIcon;
    protected String iconName;
    protected ResourceLocation icon;
    protected List<FormattedCharSequence> additionalTooltips;
    protected boolean staysOn;
    private boolean displayClickToggle = true;

    public void setDisplayClickToggle(boolean displayClickToggle) {
        this.displayClickToggle = displayClickToggle;
    }

    public ThemeButton(Theme theme, String rawLabel, String iconName, Button.OnPress onPress) {
        this(theme, Constants.getString(rawLabel), Constants.getString(rawLabel), false, iconName, onPress);
    }

    public ThemeButton(Theme theme, String rawLabel, ResourceLocation icon, Button.OnPress onPress) {
        super(Constants.getString(rawLabel), Constants.getString(rawLabel), null, onPress);
        this.icon = icon;
        this.setToggled(this.toggled);
        this.updateTheme(theme);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, boolean toggled, String iconName, Button.OnPress onPress) {
        super(Constants.getString(labelOn), Constants.getString(labelOff), null, onPress);
        this.iconName = iconName;
        this.setToggled(toggled);
        this.updateTheme(theme);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, String iconName, BooleanField field, Button.OnPress onPress) {
        super(Constants.getString(labelOn), Constants.getString(labelOff), field, onPress);
        this.iconName = iconName;
        this.updateTheme(theme);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, ResourceLocation icon, BooleanField field, Button.OnPress onPress) {
        super(Constants.getString(labelOn), Constants.getString(labelOff), field, onPress);
        this.icon = icon;
        this.updateTheme(theme);
    }

    public boolean isStaysOn() {
        return this.staysOn;
    }

    public void setStaysOn(boolean staysOn) {
        this.staysOn = staysOn;
    }

    public void updateTheme(Theme theme) {
        this.theme = theme;
        this.buttonSpec = this.getButtonSpec(theme);
        if (this.buttonSpec.useThemeImages) {
            String pattern = this.getPathPattern();
            String prefix = this.buttonSpec.prefix;
            this.textureOn = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "on"));
            this.textureOff = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "off"));
            this.textureHover = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "hover"));
            this.textureDisabled = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "disabled"));
        } else {
            this.textureOn = null;
            this.textureOff = null;
            this.textureHover = null;
            this.textureDisabled = null;
        }
        this.textureIcon = this.icon != null ? TextureCache.getThemeTextureFromResource(this.icon) : TextureCache.getThemeTexture(theme, String.format("icon/%s.png", this.iconName));
        this.setWidth(this.buttonSpec.width);
        this.setHeight(this.buttonSpec.height);
        this.setToggled(false, false);
    }

    public boolean hasValidTextures() {
        if (this.buttonSpec.useThemeImages) {
            return this.textureOn.hasImage() && this.textureOff.hasImage();
        }
        return this.textureIcon != null && this.textureIcon.hasImage();
    }

    protected String getPathPattern() {
        return "control/%sbutton_%s.png";
    }

    protected Theme.Control.ButtonSpec getButtonSpec(Theme theme) {
        return theme.control.button;
    }

    public Theme.Control.ButtonSpec getButtonSpec() {
        return this.buttonSpec;
    }

    protected Texture getActiveTexture(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.textureDisabled;
        }
        return isMouseOver ? this.textureOn : this.textureOff;
    }

    protected Theme.ColorSpec getIconColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.iconDisabled;
        }
        if (isMouseOver) {
            return this.toggled != false ? this.buttonSpec.iconHoverOn : this.buttonSpec.iconHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.iconOn : this.buttonSpec.iconOff) : this.buttonSpec.iconOff;
    }

    protected Theme.ColorSpec getButtonColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.buttonDisabled;
        }
        if (isMouseOver) {
            return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonHoverOn : this.buttonSpec.buttonHoverOff) : this.buttonSpec.buttonHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonOn : this.buttonSpec.buttonOff) : this.buttonSpec.buttonOff;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        if (!this.isVisible()) {
            return;
        }
        boolean hover = mouseX >= super.getX() && mouseY >= super.getY() && mouseX < super.getX() + this.width && mouseY < super.getY() + this.height;
        this.setMouseOver(hover);
        Texture activeTexture = this.getActiveTexture(this.isHovered());
        Theme.ColorSpec iconColorSpec = this.getIconColor(this.isHovered());
        int drawX = this.getX();
        int drawY = this.getY();
        RenderWrapper.enableDepthTest();
        if (this.buttonSpec.useThemeImages) {
            RenderWrapper.setShader(GameRenderer::getPositionTexShader);
            Theme.ColorSpec buttonColorSpec = this.getButtonColor(this.isHovered());
            float buttonScale = 1.0f;
            if (this.buttonSpec.width != activeTexture.getWidth()) {
                buttonScale = 1.0f * (float)this.buttonSpec.width / (float)activeTexture.getWidth();
            }
            DrawUtil.drawColoredImage(graphics.pose(), activeTexture, buttonColorSpec.getColor(), buttonColorSpec.alpha, drawX, drawY, buttonScale, 0.0);
        } else {
            this.drawNativeButton(graphics, mouseX, mouseY);
        }
        float iconScale = 1.0f;
        if (this.theme.icon.width != this.textureIcon.getWidth()) {
            iconScale = 1.0f * (float)this.theme.icon.width / (float)this.textureIcon.getWidth();
        }
        if (!this.buttonSpec.useThemeImages) {
            DrawUtil.drawColoredImage(graphics.pose(), this.textureIcon, 0, iconColorSpec.alpha, (double)drawX + 0.5, (double)drawY + 0.5, iconScale, 0.0);
        }
        DrawUtil.drawColoredImage(graphics.pose(), this.textureIcon, iconColorSpec.getColor(), iconColorSpec.alpha, drawX, drawY, iconScale, 0.0);
    }

    public void drawNativeButton(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.pose().pushPose();
        ResourceLocation buttonTex = SPRITES.get(this.active, this.isHoveredOrFocused());
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.enableBlend();
        RenderWrapper.blendFunc(770, 771);
        graphics.blitSprite(buttonTex, super.getX(), super.getY(), this.width, this.height);
        this.mouseDragged(mouseX, mouseY, 0, super.getX(), super.getY());
        graphics.pose().popPose();
    }

    public void setAdditionalTooltips(List<FormattedCharSequence> additionalTooltips) {
        this.additionalTooltips = additionalTooltips;
    }

    @Override
    public List<FormattedCharSequence> getWrappedTooltip() {
        if (!this.visible) {
            return null;
        }
        List<FormattedCharSequence> list = super.getWrappedTooltip();
        String styleCode = null;
        styleCode = !this.isEnabled() ? this.buttonSpec.tooltipDisabledStyle : (this.toggled != false ? this.buttonSpec.tooltipOnStyle : this.buttonSpec.tooltipOffStyle);
        Style style = styleCode.isEmpty() || "".equals(styleCode) ? Style.EMPTY : Style.EMPTY.applyFormat(ChatFormatting.getByCode((char)styleCode.charAt(1)));
        list.add(0, FormattedCharSequence.forward((String)this.getMessage().getString(), (Style)style));
        if (this.additionalTooltips != null) {
            list.addAll(this.additionalTooltips);
        }
        return list;
    }

    public Button getButton() {
        return this;
    }
}

