/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.copyconfig;

import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.ClientPropertiesBase;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CopyConfigScreen
extends PopupButtonScreen<Category> {
    private final LinearLayout layout = LinearLayout.vertical();
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.parse((String)"popup/background");
    private final Component labelCancel = Component.translatable((String)"jm.common.cancel");
    private final Category[] to;
    private final Category from;

    public CopyConfigScreen(Category from, Category[] to) {
        super((Component)Component.translatable((String)"jm.common.options.copy_to"));
        this.to = to;
        this.from = from;
    }

    public void init() {
        LinearLayout bottomButtons = LinearLayout.vertical();
        this.layout.spacing(6).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)this.getButton(this.to[0], b -> this.respond(0)));
        this.layout.addChild((LayoutElement)this.getButton(this.to[1], b -> this.respond(1)));
        this.layout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> super.onClose()).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void respond(int index) {
        this.copy(this.to[index]);
        this.setResponseAndClose(this.to[index]);
    }

    private Button getButton(Category category, Button.OnPress onPress) {
        String tooltip = "";
        String name = "";
        if (ClientCategory.MiniMap1.equals(category)) {
            name = Constants.getString("jm.common.copy_config.minimap1");
            tooltip = Constants.getString("jm.common.copy_config.minimap1.tooltip");
        }
        if (ClientCategory.FullMap.equals(category)) {
            name = Constants.getString("jm.common.copy_config.fullscreen");
            tooltip = Constants.getString("jm.common.copy_config.fullscreen.tooltip");
        }
        if (ClientCategory.MiniMap2.equals(category)) {
            name = Constants.getString("jm.common.copy_config.minimap2");
            tooltip = Constants.getString("jm.common.copy_config.minimap2.tooltip");
        }
        return Button.builder((Component)Component.literal((String)name), (Button.OnPress)onPress).tooltip(Tooltip.create((Component)Component.literal((String)tooltip))).width(this.font.width(name) + 10).build();
    }

    public void copy(Category categoryTo) {
        ClientPropertiesBase from = this.getProperties(this.from);
        ClientPropertiesBase to = this.getProperties(categoryTo);
        if (to != null && from != null) {
            InGameMapProperties properties;
            Integer id = null;
            if (to instanceof InGameMapProperties) {
                properties = (InGameMapProperties)to;
                id = properties.getPropertiesId();
            }
            to.updateFrom(from);
            if (to instanceof InGameMapProperties) {
                properties = (InGameMapProperties)to;
                properties.setPropertiesId(id);
            }
            to.save();
            Journeymap.getLogger().info("Copied common options from {} to {}.", (Object)from.getFileName(), (Object)to.getFileName());
        }
    }

    private ClientPropertiesBase getProperties(Category category) {
        if (ClientCategory.FullMap.equals(category)) {
            return JourneymapClient.getInstance().getFullMapProperties();
        }
        if (ClientCategory.MiniMap1.equals(category)) {
            return JourneymapClient.getInstance().getMiniMapProperties1();
        }
        if (ClientCategory.MiniMap2.equals(category)) {
            return JourneymapClient.getInstance().getMiniMapProperties2();
        }
        return null;
    }

    @Override
    public void renderPopupScreenBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
        graphics.blitSprite(BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }
}

