/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.NativeImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.log.JMLogger;
import journeymap.client.render.RenderWrapper;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.RegionMipmapGenerator;
import journeymap.client.texture.Texture;
import journeymap.common.Journeymap;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ChunkPos;

public class RegionTexture
extends AbstractTexture
implements Texture {
    protected final ReentrantLock bufferLock = new ReentrantLock();
    protected Set<ChunkPos> dirtyChunks = new HashSet<ChunkPos>();
    protected List<WeakReference<Listener>> listeners = new ArrayList<WeakReference<Listener>>(0);
    protected long lastImageUpdate;
    protected String description;
    protected boolean bindNeeded;
    protected long lastBound;
    protected NativeImage image;
    protected NativeImage[] mipmaps;
    protected int width;
    protected int height;
    protected final int mipmapLevels;

    public RegionTexture(NativeImage pixels, String description) {
        this.mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
        this.setNativeImage(pixels, true);
        this.description = description;
        this.mipmaps = RegionMipmapGenerator.generateMipmaps(this.image, this.mipmapLevels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() {
        if (this.bindNeeded && this.bufferLock.tryLock()) {
            try {
                int err;
                if (this.id == -1) {
                    this.id = this.getId();
                }
                super.bind();
                if (this.lastBound == 0L || this.dirtyChunks.isEmpty()) {
                    int i;
                    if (this.mipmaps == null) {
                        this.mipmaps = RegionMipmapGenerator.generateMipmaps(this.image, this.mipmapLevels);
                    }
                    RenderWrapper.texParameter(3553, 10241, 9984);
                    RenderWrapper.texParameter(3553, 10240, 9728);
                    RenderWrapper.texParameter(3553, 10242, 33071);
                    RenderWrapper.texParameter(3553, 10243, 33071);
                    RenderWrapper.texParameter(3553, 33085, this.mipmapLevels);
                    RenderWrapper.texParameter(3553, 33082, 0);
                    RenderWrapper.texParameter(3553, 33083, this.mipmapLevels);
                    RenderWrapper.texParameter(3553, 34049, 0);
                    for (i = 0; i <= this.mipmapLevels; ++i) {
                        RenderWrapper.texImage2D(3553, i, this.image.format().glFormat(), this.mipmaps[i].getWidth(), this.mipmaps[i].getHeight(), 0, 6408, 5121, null);
                    }
                    for (i = 0; i <= this.mipmapLevels; ++i) {
                        NativeImage image = this.mipmaps[i];
                        if (image == null || image.pixels == 0L) continue;
                        image.upload(i, 0, 0, 0, 0, this.mipmaps[i].getWidth(), this.mipmaps[i].getHeight(), false, false, true, false);
                    }
                    this.bindNeeded = false;
                    this.lastBound = System.currentTimeMillis();
                    return;
                }
                for (ChunkPos pos : this.dirtyChunks) {
                    NativeImage chunkImage = ImageUtil.getSubImage(pos.x, pos.z, 16, 16, this.image, false);
                    try {
                        if (chunkImage.pixels == 0L) continue;
                        chunkImage.copyRect(this.image, 0, 0, pos.x, pos.z, 16, 16, false, false);
                        chunkImage.upload(0, pos.x, pos.z, 0, 0, 16, 16, true, false);
                    }
                    finally {
                        if (chunkImage == null) continue;
                        chunkImage.close();
                    }
                }
                RegionMipmapGenerator.updateMipmapsAndUpload(this.mipmaps, this.dirtyChunks);
                while ((err = RenderWrapper.getError()) != 0) {
                    JMLogger.logOnce("GL Error in RegionTexture after upload: " + err + " in " + String.valueOf(this));
                }
                this.dirtyChunks.clear();
                this.lastBound = System.currentTimeMillis();
                this.bindNeeded = false;
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Can't bind texture: ", t);
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public boolean isBound() {
        return this.id != -1;
    }

    public boolean isDefunct() {
        return this.image == null && this.id == -1 || this.image != null && this.image.pixels == 0L;
    }

    @Override
    public void setNativeImage(NativeImage image, boolean retainImage) {
        if (image == null) {
            return;
        }
        this.handleImage(image, retainImage);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    @Override
    public Integer getRGB(int x, int y) {
        int rgba = this.image.getPixelRGBA(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    @Override
    public void release() {
        super.releaseId();
    }

    public void setNativeImage(NativeImage image, boolean retainImage, HashSet<ChunkPos> updatedChunks) {
        if (image == null) {
            return;
        }
        this.handleImage(image, retainImage);
        this.dirtyChunks.addAll(updatedChunks);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    private void handleImage(NativeImage image, boolean retainImage) {
        this.bindNeeded = true;
        try {
            this.bufferLock.lock();
            this.width = image.getWidth();
            this.height = image.getHeight();
            if (retainImage) {
                if (this.image == null) {
                    this.image = image;
                } else if (image.pixels != this.image.pixels) {
                    this.image.copyFrom(image);
                }
            }
            if (image.pixels != this.image.pixels) {
                this.clearMipmaps();
                image.close();
            }
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    public Set<ChunkPos> getDirtyAreas() {
        return this.dirtyChunks;
    }

    public void addListener(Listener addedListener) {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            if (addedListener != listener) continue;
            return;
        }
        this.listeners.add(new WeakReference<Listener>(addedListener));
    }

    protected void notifyListeners() {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.textureImageUpdated(this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("glid", this.id).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).toString();
    }

    public boolean bindNeeded() {
        return this.bindNeeded;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public void setDisplayWidth(int width) {
    }

    @Override
    public void setDisplayHeight(int height) {
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        return null;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public boolean hasImage() {
        return this.image != null && this.image.pixels > 0L;
    }

    @Override
    public void remove() {
        this.bufferLock.lock();
        ImageUtil.closeSafely(this.image);
        this.bufferLock.unlock();
        this.bindNeeded = false;
        this.image = null;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.id = -1;
        this.clearMipmaps();
    }

    private void clearMipmaps() {
        if (this.mipmaps != null) {
            for (int i = 1; i <= this.mipmapLevels; ++i) {
                if (this.mipmaps[i] == null) continue;
                ImageUtil.closeSafely(this.mipmaps[i]);
                this.mipmaps[i] = null;
            }
            this.mipmaps = null;
        }
    }

    public void close() {
        if (this.isBound()) {
            ExpireTextureTask.queue(this.id);
        }
        this.image.close();
    }

    @Override
    public void setNativeImage(NativeImage image) {
        this.setNativeImage(image, true);
    }

    @Override
    public NativeImage getNativeImage() {
        return this.image;
    }

    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    @Override
    public float getAlpha() {
        return 0.0f;
    }

    @Override
    public void setAlpha(float alpha) {
    }

    public void load(ResourceManager pResourceManager) {
    }

    public static interface Listener<T extends Texture> {
        public void textureImageUpdated(T var1);
    }
}

