/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import com.google.gson.annotations.Since;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.common.waypoint.GroupSettings;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class WaypointGroupImpl
implements WaypointGroup {
    @Since(value=1.0)
    protected String version = "1";
    @Since(value=1.0)
    protected final String guid;
    @Since(value=1.0)
    protected GroupSettings settings;
    @Since(value=1.0)
    protected String name;
    @Since(value=1.0)
    protected final String modId;
    @Since(value=1.0)
    protected String description;
    @Since(value=1.0)
    protected WaypointIcon icon;
    @Since(value=1.0)
    protected Integer color;
    protected boolean locked;
    protected transient boolean dirty;
    protected String customData;

    public WaypointGroupImpl(String modId, String name, String guid) {
        this.guid = guid;
        this.modId = modId;
        this.name = name;
        this.settings = new GroupSettings();
        this.icon = new WaypointIcon();
    }

    public WaypointGroupImpl(String modId, String name) {
        this(modId, name, UUID.randomUUID().toString());
    }

    public WaypointGroupImpl(String name, String version, String modId, String guid, Optional<String> description, Optional<Integer> color, WaypointIcon icon, GroupSettings settings, Optional<String> customData) {
        this.version = version;
        this.guid = guid;
        this.settings = settings;
        this.name = name;
        this.modId = modId;
        description.ifPresent(this::setDescription);
        customData.ifPresent(this::setCustomData);
        this.icon = icon;
        this.color = color.orElse(null);
    }

    public void setVersion(String version) {
        this.version = version;
        this.setDirty();
    }

    public void setSettings(GroupSettings settings) {
        this.settings = settings;
        this.setDirty();
    }

    public void setIcon(WaypointIcon icon) {
        this.icon = icon;
        this.setDirty();
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer color) {
        this.color = color;
        this.setDirty();
    }

    public List<String> getWaypointIds() {
        return WaypointGroupStore.getInstance().getWaypointsIds(this);
    }

    public int count() {
        return WaypointGroupStore.getInstance().getWaypointsIds(this).size();
    }

    public String getGuid() {
        return this.guid;
    }

    public GroupSettings getSettings() {
        return this.settings;
    }

    public WaypointIcon getIcon() {
        return this.icon;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setDirty();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setDirty();
    }

    public boolean isEnabled() {
        return this.settings.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.settings.setEnabled(enabled);
        this.setDirty();
    }

    public boolean showDeviation() {
        return this.settings.showDeviation();
    }

    public void setShowDeviation(boolean deviation) {
        this.settings.setShowDeviation(deviation);
        this.setDirty();
    }

    public boolean isLocked() {
        return this.settings.isLocked();
    }

    public void setLocked(boolean locked) {
        this.settings.setLocked(locked);
        this.setDirty();
    }

    public boolean colorOverride() {
        return this.settings.isColorOverride();
    }

    public void setColorOverride(boolean colorOverride) {
        this.settings.setColorOverride(colorOverride);
    }

    public int getIconRotation() {
        return this.icon.getRotation();
    }

    public void setIconRotation(int rotation) {
        this.icon.setRotation(rotation);
        this.setDirty();
    }

    public Integer getIconColor() {
        return this.icon.getColor();
    }

    public void setIconColor(Integer color) {
        this.icon.setColor(color);
        this.setDirty();
    }

    public float getIconOpacity() {
        return this.icon.getOpacity();
    }

    public void setIconOpacity(float opacity) {
        this.icon.setOpacity(opacity);
        this.setDirty();
    }

    public ResourceLocation getIconResourceLocation() {
        return this.icon.getResourceLocation();
    }

    public void setIconResourceLoctaion(ResourceLocation resourceLocation) {
        this.icon.setResourceLoctaion(resourceLocation);
        this.setDirty();
    }

    public int getIconTextureWidth() {
        return this.icon.getTextureWidth();
    }

    public void setIconTextureWidth(Integer width) {
        this.icon.setTextureWidth(width);
        this.setDirty();
    }

    public int getIconTextureHeight() {
        return this.icon.getTextureHeight();
    }

    public void setIconTextureHeight(Integer height) {
        this.icon.setTextureHeight(height);
        this.setDirty();
    }

    public void setCustomData(@Nullable String customData) {
        this.customData = customData;
    }

    @Nullable
    public String getCustomData() {
        return this.customData;
    }

    public boolean addWaypoint(Waypoint waypoint) {
        return WaypointGroupStore.getInstance().transferWaypoint(this, waypoint.getGuid());
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isDirty() {
        return this.dirty || this.settings.isDirty() || this.icon.isDirty();
    }

    public void setDirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.settings.setDirty(dirty);
        this.icon.setDirty(dirty);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaypointGroupImpl group = (WaypointGroupImpl)o;
        return this.guid.equals(group.guid);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.guid.hashCode();
        return result;
    }
}

