/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class WaypointPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"waypoint");
    private String action;
    private String waypoint;
    private boolean announce;

    public WaypointPacket() {
    }

    public WaypointPacket(String waypoint, boolean announce, String action) {
        this.action = action;
        this.waypoint = waypoint;
        this.announce = announce;
    }

    public static WaypointPacket decode(FriendlyByteBuf buf) {
        WaypointPacket packet = new WaypointPacket();
        try {
            if (buf.readableBytes() > 1) {
                packet.waypoint = buf.readUtf();
                packet.action = buf.readUtf();
                packet.announce = buf.readBoolean();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for waypoint: %s", t));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.writeUtf(this.waypoint);
            buf.writeUtf(this.action);
            buf.writeBoolean(this.announce);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for waypoint: " + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<WaypointPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            JourneymapClient.getInstance().getPacketHandler().onWaypointCreatePacket(((WaypointPacket)ctx.message()).waypoint, ((WaypointPacket)ctx.message()).action, ((WaypointPacket)ctx.message()).announce);
        }
    }
}

