/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class MultiplayerOptionsPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"mp_options_req");
    private String payload;

    public MultiplayerOptionsPacket() {
    }

    public MultiplayerOptionsPacket(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public static MultiplayerOptionsPacket decode(FriendlyByteBuf buf) {
        MultiplayerOptionsPacket packet = new MultiplayerOptionsPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.payload = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for multiplayer options request: %s", t));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null) {
                buf.writeByte(42);
                buf.writeUtf(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for multiplayer options request:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<MultiplayerOptionsPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            if (((MultiplayerOptionsPacket)ctx.message()).getPayload() == null) {
                Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsOpen(ctx.sender());
            } else {
                Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsSave(ctx.sender(), ((MultiplayerOptionsPacket)ctx.message()).getPayload());
            }
        } else {
            JourneymapClient.getInstance().getPacketHandler().onMultiplayerDataResponse(((MultiplayerOptionsPacket)ctx.message()).getPayload());
        }
    }
}

