/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.handler;

import journeymap.client.JourneymapClient;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.MultiplayerOptionsManager;
import journeymap.client.ui.option.ServerOptionsManager;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.network.model.ClientState;
import journeymap.common.network.model.PlayerLocation;
import journeymap.common.network.model.ServerPropertyType;
import journeymap.common.util.PlayerRadarManager;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointOrigin;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ClientPacketHandler {
    public void onClientStateUpdate(ClientState packet) {
        JourneymapClient.getInstance().getStateHandler().setStates(packet);
    }

    public void onServerAdminDataResponse(int type, String payload, String dimension) {
        ServerOptionsManager serverOptionsManager = UIManager.INSTANCE.getServerEditor();
        if (serverOptionsManager != null) {
            serverOptionsManager.setData(ServerPropertyType.getFromType(type), payload, dimension);
        }
    }

    public void onMultiplayerDataResponse(String payload) {
        MultiplayerOptionsManager multiplayerOptionsManager = UIManager.INSTANCE.getMultiplayerOptions();
        if (multiplayerOptionsManager != null) {
            multiplayerOptionsManager.setData(payload);
        }
    }

    public void onPlayerLocationPacket(PlayerLocation packet) {
        PlayerRadarManager.getInstance().updatePlayers(packet);
    }

    public void onWaypointCreatePacket(String waypoint, String action, boolean announce) {
        MutableComponent message = null;
        if ("create".equalsIgnoreCase(action)) {
            ClientWaypointImpl clientWaypoint = ClientWaypointImpl.fromString(waypoint);
            if (WaypointOrigin.EXTERNAL_FORCE.getValue().equals(clientWaypoint.getOrigin())) {
                clientWaypoint.setPersistent(false);
            }
            WaypointStore.getInstance().save(clientWaypoint, true);
            Fullscreen.state().requireRefresh();
            message = Component.translatable((String)"jm.common.waypoint.create_packet", (Object[])new Object[]{clientWaypoint.getPrettyName(), clientWaypoint.getX(), clientWaypoint.getY(), clientWaypoint.getZ(), clientWaypoint.getDimensions()});
        } else if ("delete".equalsIgnoreCase(action)) {
            WaypointImpl commandWaypoint = WaypointImpl.fromJsonString(waypoint);
            for (ClientWaypointImpl wp : WaypointStore.getInstance().getAll()) {
                if (!commandWaypoint.getName().equalsIgnoreCase(wp.getName()) || !wp.getOrigin().equals(commandWaypoint.getOrigin()) || !ClientPacketHandler.validOrigin(commandWaypoint.getOrigin())) continue;
                WaypointStore.getInstance().remove(wp, true);
                message = Component.translatable((String)"jm.common.waypoint.delete_packet", (Object[])new Object[]{wp.getPrettyName()});
                break;
            }
        } else {
            Journeymap.getLogger().warn("Error invalid action is being sent: \"{}\", \"create\" and \"delete\" are accepted values", (Object)action);
            return;
        }
        if (announce && message != null) {
            Minecraft.getInstance().gui.getChat().addMessage(message);
        }
        if (message != null) {
            Journeymap.getLogger().info(message.getString());
        }
    }

    private static boolean validOrigin(String origin) {
        return WaypointOrigin.fromValue(origin) != null;
    }

    public void onWorldIdReceived(String worldId) {
        JourneymapClient.getInstance().setCurrentWorldId(worldId);
    }
}

