/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.mixin.client;

import journeymap.client.event.handlers.HudOverlayHandler;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class}, priority=1500)
public class ForgeGuiMixin {
    private boolean shouldPop = false;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="TAIL")})
    public void renderPost(GuiGraphics graphics, DeltaTracker partialTicks, CallbackInfo callbackInfo) {
        if (!Minecraft.getInstance().gui.getDebugOverlay().showDebugScreen()) {
            HudOverlayHandler.getInstance().onRenderOverlay(graphics);
        }
    }

    @Inject(method={"renderEffects(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="HEAD")})
    public void renderEffectPre(GuiGraphics graphics, DeltaTracker f, CallbackInfo ci) {
        this.shouldPop = HudOverlayHandler.getInstance().preOverlay(graphics);
    }

    @Inject(method={"renderEffects(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="RETURN")})
    public void renderEffectPost(GuiGraphics graphics, DeltaTracker f, CallbackInfo callbackInfo) {
        if (this.shouldPop) {
            HudOverlayHandler.getInstance().postOverlay(graphics);
            this.shouldPop = false;
        }
    }
}

