/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helpers;

import com.google.common.base.Joiner;
import com.mojang.authlib.GameProfile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import journeymap.api.services.CommonPlatformService;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.common.CommonConstants;
import journeymap.common.helpers.ForgeObfHelper;
import journeymap.common.util.ObfuscationHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.objectweb.asm.Type;

public class ForgeHooks
implements CommonPlatformService {
    private final ObfuscationHelper obfuscationHelper = new ForgeObfHelper();

    @Override
    public CommonPlatformService.Loader getLoader() {
        return CommonPlatformService.Loader.FORGE;
    }

    @Override
    public boolean isDedicatedServer() {
        return this.getServer().isDedicatedServer();
    }

    @Override
    public MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public ArrayList<String> getMods() {
        ArrayList<String> list = new ArrayList<String>();
        for (IModInfo mod : ModList.get().getMods()) {
            if (!ModList.get().isLoaded(mod.getModId())) continue;
            list.add(String.format("%s:%s", mod.getDisplayName(), mod.getVersion()));
        }
        return list;
    }

    @Override
    public String getModName(String modId) {
        for (IModInfo mod : ModList.get().getMods()) {
            if (!mod.getModId().equals(modId)) continue;
            return mod.getDisplayName();
        }
        return "";
    }

    @Override
    public String getModNames() {
        return Joiner.on((String)", ").join(this.getMods().stream().sorted().iterator());
    }

    @Override
    public String getLoaderVersion() {
        return ForgeVersion.getVersion();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId) || ModList.get().isLoaded(modId.toLowerCase());
    }

    @Override
    public URL getModFileLocation(String domain) throws Exception {
        URL fileLocation = null;
        ModContainer mod = ModList.get().getModContainerById(domain).orElse(null);
        if (mod == null) {
            for (IModInfo modEntry : ModList.get().getMods()) {
                if (!modEntry.getModId().toLowerCase().equals(domain)) continue;
                mod = ModList.get().getModContainerById(domain).orElse(null);
                break;
            }
        }
        if (mod != null) {
            fileLocation = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath().toUri().toURL();
        }
        return fileLocation;
    }

    @Override
    public boolean isClient() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public boolean isOp(Player player) {
        if (LogicalSide.CLIENT.equals((Object)EffectiveSide.get())) {
            boolean creative = player.getAbilities().instabuild;
            boolean cheatMode = this.getServer().getPlayerList().isOp(new GameProfile(player.getUUID(), player.getName().getString()));
            return creative || cheatMode;
        }
        return this.getServer().getPlayerList().getOps().get((Object)player.getGameProfile()) != null || CommonConstants.debugOverride((Entity)player);
    }

    @Override
    public List<String> getClientPluginScanResult() {
        List<String> annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(annotationData -> Objects.equals(annotationData.annotationType(), Type.getType(JourneyMapPlugin.class))).map(ModFileScanData.AnnotationData::memberName).collect(Collectors.toList());
        return annotations;
    }

    @Override
    public ObfuscationHelper getObfHelper() {
        return this.obfuscationHelper;
    }
}

