/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.util.function.Consumer;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.waypointmanager.waypoint.DimensionSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;

public class DimensionPanel<T extends DimensionSlot>
extends ScrollListPane<T> {
    final int offset = 7;

    public DimensionPanel(Minecraft mc, int width, int height, int slotHeight) {
        super(mc, 0, 0, width, height, slotHeight);
        this.hpad = 1;
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.setRectangle(width, height, x - 3, y);
        this.scrollbarX = this.width + x - 7;
        this.listWidth = this.width - 7;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2 - 7;
        this.listWidth = width - 7;
    }

    public void visitSlots(Consumer<AbstractWidget> consumer) {
        this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(consumer));
    }

    public void initSlots() {
        this.getRootSlots().forEach(DimensionSlot::init);
    }

    public void repositionSlots() {
        this.getRootSlots().forEach(DimensionSlot::repositionElements);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(widget -> widget.mouseClicked(mouseX, mouseY, button)));
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY(), 1.0, this.height, 0x404040, this.alpha);
    }

    public void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int i = this.getX() + (this.width - width) / 2 + 2;
        int j = this.getX() + (this.width + width) / 2 - 4;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    public void setX(int x) {
        super.setX(x);
        this.scrollbarX = this.width + x - 7;
    }
}

