/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class DeleteConfirmWaypointPopup
extends PopupButtonScreen<Boolean> {
    private final LinearLayout layout = LinearLayout.vertical();
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.parse((String)"popup/background");

    protected DeleteConfirmWaypointPopup(Waypoint waypoint) {
        super((Component)Component.translatable((String)"jm.waypoint.delete.confirm.title", (Object[])new Object[]{waypoint.getName()}));
    }

    protected void init() {
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(150).setCentered(true));
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(6);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.delete"), b -> this.delete()).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> super.onClose()).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    @Override
    public void renderPopupScreenBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    private void delete() {
        this.setResponseAndClose(true);
    }

    @Override
    protected void onClosed() {
        this.onClose.closed((Boolean)this.response);
        super.onClose();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }
}

