/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.legacy;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.TreeSet;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.SimpleTextureImpl;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.ScrollPane;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.OnOffButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.waypointmanager.legacy.LegacyWaypointManager;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.util.Strings;

public class WaypointEditor
extends JmUILegacy {
    private final Texture wpTexture;
    private final Texture colorPickTexture;
    private final ClientWaypointImpl originalWaypoint;
    private final boolean isNew;
    String labelName = Constants.getString("jm.waypoint.name");
    String locationTitle = Constants.getString("jm.waypoint.location");
    String colorTitle = Constants.getString("jm.waypoint.color");
    String dimensionsTitle = Constants.getString("jm.waypoint.dimensions");
    String labelX = Constants.getString("jm.waypoint.x");
    String labelY = Constants.getString("jm.waypoint.y");
    String labelZ = Constants.getString("jm.waypoint.z");
    String labelR = Constants.getString("jm.waypoint.red_abbreviated");
    String labelG = Constants.getString("jm.waypoint.green_abbreviated");
    String labelB = Constants.getString("jm.waypoint.blue_abbreviated");
    String currentLocation = "";
    LocationFormat.LocationFormatKeys locationFormatKeys;
    private Button buttonRandomize;
    private OnOffButton buttonEnable;
    private Button buttonRemove;
    private Button buttonReset;
    private Button buttonSave;
    private Button buttonClose;
    private TextBox fieldName;
    private TextBox fieldR;
    private TextBox fieldG;
    private TextBox fieldB;
    private TextBox fieldX;
    private TextBox fieldY;
    private TextBox fieldZ;
    private ArrayList<TextBox> fieldList = new ArrayList();
    private ArrayList<DimensionButton> dimButtonList = new ArrayList();
    private ScrollPane dimScrollPane;
    private Integer currentColor;
    private Rectangle2D.Double colorPickRect;
    private String colorPickTooltip;
    private ClientWaypointImpl editedWaypoint;
    private ButtonList bottomButtons;
    private float partialTicks;
    private boolean openedWithHotKey = true;
    private final int bottomY = -100;

    public WaypointEditor(ClientWaypointImpl waypoint, boolean isNew, boolean openedWithHotKey, Screen returnDisplay) {
        super(Constants.getString(isNew ? "jm.waypoint.new_title" : "jm.waypoint.edit_title"), returnDisplay);
        String tooltip;
        this.originalWaypoint = waypoint;
        this.openedWithHotKey = openedWithHotKey;
        try {
            this.editedWaypoint = new ClientWaypointImpl((Waypoint)this.originalWaypoint);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        this.isNew = isNew;
        this.wpTexture = waypoint.getTexture();
        this.colorPickTooltip = tooltip = Constants.birthdayMessage();
        this.colorPickTexture = tooltip == null ? TextureCache.getTexture(TextureCache.ColorPicker) : TextureCache.getTexture(TextureCache.ColorPicker2);
        try {
            this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, this.colorPickTexture.getWidth(), this.colorPickTexture.getHeight());
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor ctor: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    public void init() {
        try {
            this.setRenderBottomBar(true);
            FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
            LocationFormat locationFormat = new LocationFormat();
            this.locationFormatKeys = locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
            String pos = this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), Mth.floor((double)this.minecraft.player.getX()), Mth.floor((double)this.minecraft.player.getZ()), Mth.floor((double)this.minecraft.player.getBoundingBox().minY), Mth.floor((float)(this.minecraft.player.getBlockY() >> 4)));
            this.currentLocation = Constants.getString("jm.waypoint.current_location", " " + pos);
            if (this.fieldList.isEmpty()) {
                Font fr = this.getFontRenderer();
                this.fieldName = new TextBox(this.originalWaypoint.getName(), fr, 160, 20);
                if (this.isNew) {
                    this.fieldName.setFocused(true);
                    this.fieldName.moveCursorToEnd(true);
                    this.fieldName.setHighlightPos(0);
                }
                this.fieldList.add(this.fieldName);
                int width9chars = this.getFontRenderer().width("-30000000") + 10;
                int width3chars = this.getFontRenderer().width("255") + 10;
                int width4chars = this.getFontRenderer().width("-255") + 10;
                int h = 20;
                this.fieldX = new TextBox(this.originalWaypoint.getRawX(), fr, width9chars, h, true, true);
                this.fieldX.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldX);
                this.fieldZ = new TextBox(this.originalWaypoint.getRawZ(), fr, width9chars, h, true, true);
                this.fieldZ.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldZ);
                int y = this.originalWaypoint.getY();
                this.fieldY = new TextBox(y, fr, width4chars, h, true, true);
                this.fieldY.setClamp(-99, this.minecraft.level.getMaxBuildHeight() - 1);
                this.fieldY.setMinLength(1);
                this.fieldList.add(this.fieldY);
                this.fieldR = new TextBox("", fr, width3chars, h, true, false);
                this.fieldR.setClamp(0, 255);
                this.fieldR.setMaxLength(3);
                this.fieldList.add(this.fieldR);
                this.fieldG = new TextBox("", fr, width3chars, h, true, false);
                this.fieldG.setClamp(0, 255);
                this.fieldG.setMaxLength(3);
                this.fieldList.add(this.fieldG);
                this.fieldB = new TextBox("", fr, width3chars, h, true, false);
                this.fieldB.setClamp(0, 255);
                this.fieldB.setMaxLength(3);
                this.fieldList.add(this.fieldB);
                TreeSet<String> wpDims = this.originalWaypoint.getDimensions();
                for (WorldData.DimensionProvider provider : WorldData.getDimensionProviders(WaypointStore.getInstance().getLoadedDimensions())) {
                    String dimName = WorldData.getSafeDimensionName(provider);
                    String dimId = provider.getDimensionId();
                    try {
                        dimName = provider.getName();
                    }
                    catch (Exception e) {
                        JMLogger.throwLogOnce("Can't get dimension name from provider: ", e);
                    }
                    DimensionButton button2 = new DimensionButton(this, dimId, dimName, wpDims.contains(dimId), this.originalWaypoint.getPrimaryDimension().equals(provider.getDimensionId()));
                    button2.setDefaultStyle(false);
                    this.dimButtonList.add(button2);
                }
                this.dimScrollPane = new ScrollPane(this, this.minecraft, 0, 0, this.dimButtonList, this.dimButtonList.get(0).getHeight(), 4);
                this.dimScrollPane.setRenderSelection(false);
            }
            if (this.getRenderables().isEmpty()) {
                String on = Constants.getString("jm.common.on");
                String off = Constants.getString("jm.common.off");
                String enableOn = Constants.getString("jm.waypoint.enable", on);
                String enableOff = Constants.getString("jm.waypoint.enable", off);
                this.buttonRandomize = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.waypoint.randomize"), button -> this.setRandomColor()));
                this.buttonEnable = (OnOffButton)this.addRenderableWidget((GuiEventListener)new OnOffButton(enableOn, enableOff, true, button -> this.buttonEnable.toggle()));
                this.buttonEnable.setToggled(this.originalWaypoint.isEnabled());
                this.buttonRemove = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.waypoint.remove"), button -> this.remove()));
                this.buttonRemove.setEnabled(!this.isNew);
                this.buttonReset = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.waypoint.reset"), button -> this.resetForm()));
                this.buttonSave = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.waypoint.save"), button -> this.save()));
                String closeLabel = this.isNew ? "jm.waypoint.cancel" : "jm.common.close";
                this.buttonClose = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString(closeLabel), button -> this.refreshAndClose(this.originalWaypoint)));
                this.getRenderables().add((Renderable)this.buttonEnable);
                this.getRenderables().add((Renderable)this.buttonRandomize);
                this.getRenderables().add((Renderable)this.buttonRemove);
                this.getRenderables().add((Renderable)this.buttonReset);
                this.getRenderables().add((Renderable)this.buttonSave);
                this.getRenderables().add((Renderable)this.buttonClose);
                this.buttonEnable.setDefaultStyle(false);
                this.buttonRandomize.setDefaultStyle(false);
                this.buttonRemove.setDefaultStyle(false);
                this.buttonReset.setDefaultStyle(false);
                this.buttonSave.setDefaultStyle(false);
                this.buttonClose.setDefaultStyle(false);
                this.bottomButtons = new ButtonList(this.buttonRemove, this.buttonSave, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.setFormColor(this.originalWaypoint.getIconColor());
                this.validate();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics) {
        try {
            this.init();
            Font fr = this.getFontRenderer();
            int vpad = 5;
            int hgap = fr.width("X") * 3;
            int vgap = this.fieldX.getHeight() + 5;
            int startY = Math.max(30, (this.height - 200) / 2);
            int dcw = fr.width(this.dimensionsTitle);
            dcw = 8 + Math.max(dcw, this.dimScrollPane.getFitWidth(fr));
            int leftWidth = hgap * 2 + this.fieldX.getWidth() + this.fieldY.getWidth() + this.fieldZ.getWidth();
            int rightWidth = dcw;
            int totalWidth = leftWidth + 10 + rightWidth;
            int leftX = (this.width - totalWidth) / 2;
            int leftXEnd = leftX + leftWidth;
            int rightX = leftXEnd + 10;
            int rightXEnd = rightX + rightWidth;
            int leftRowY = startY;
            this.drawLabel(graphics, this.labelName, leftX, leftRowY);
            this.fieldName.setWidth(leftWidth);
            this.fieldName.setX(leftX);
            this.fieldName.setY(leftRowY += 12);
            this.fieldName.render(graphics, leftX, leftRowY, this.partialTicks);
            this.drawLabel(graphics, this.locationTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(graphics, this.labelX, this.fieldX, leftX, leftRowY += 12);
            this.drawLabelAndField(graphics, this.labelZ, this.fieldZ, this.fieldX.getX() + this.fieldX.getWidth() + hgap, leftRowY);
            this.drawLabelAndField(graphics, this.labelY, this.fieldY, this.fieldZ.getX() + this.fieldZ.getWidth() + hgap, leftRowY);
            this.drawLabel(graphics, this.colorTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(graphics, this.labelR, this.fieldR, leftX, leftRowY += 12);
            this.drawLabelAndField(graphics, this.labelG, this.fieldG, this.fieldR.getX() + this.fieldR.getWidth() + hgap, leftRowY);
            this.drawLabelAndField(graphics, this.labelB, this.fieldB, this.fieldG.getX() + this.fieldG.getWidth() + hgap, leftRowY);
            this.buttonRandomize.setWidth(4 + Math.max(this.fieldB.getX() + this.fieldB.getWidth() - this.fieldR.getX(), 10 + fr.width(this.buttonRandomize.getMessage().getString())));
            this.buttonRandomize.setScrollablePosition(this.fieldR.getX() - 2, leftRowY += vgap);
            int cpY = this.fieldB.getY();
            int cpSize = this.buttonRandomize.getY() + this.buttonRandomize.getHeight() - cpY - 2;
            int cpHAreaX = this.fieldB.getX() + this.fieldB.getWidth();
            int cpHArea = this.fieldName.getX() + this.fieldName.getWidth() - cpHAreaX;
            int cpX = cpHAreaX + (cpHArea - cpSize);
            this.drawColorPicker(graphics, cpX, cpY, cpSize);
            int iconX = cpHAreaX + (cpX - cpHAreaX) / 2 - this.wpTexture.getWidth() / 2 + 1;
            int iconY = this.buttonRandomize.getY() - 2;
            this.drawWaypoint(graphics, iconX, iconY);
            this.buttonEnable.fitWidth(fr);
            this.buttonEnable.setWidth(Math.max(leftWidth / 2, this.buttonEnable.getWidth()));
            this.buttonEnable.setScrollablePosition(leftX - 2, leftRowY += vgap);
            this.buttonReset.setWidth(leftWidth - this.buttonEnable.getWidth() - 2);
            this.buttonReset.setScrollablePosition(leftXEnd - this.buttonReset.getWidth() + 2, leftRowY);
            int rightRow = startY;
            this.drawLabel(graphics, this.dimensionsTitle, rightX, rightRow);
            int scrollHeight = this.buttonReset.getY() + this.buttonReset.getHeight() - 2 - (rightRow += 12);
            this.dimScrollPane.setDimensions(dcw, scrollHeight, 0, 0, rightX, rightRow);
            int totalRow = Math.max(leftRowY + vgap, rightRow + vgap);
            this.bottomButtons.layoutFilledHorizontal(fr, leftX - 2, totalRow, rightXEnd + 2, 4, true);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        try {
            this.partialTicks = partialTicks;
            super.renderBackground(graphics, x, y, partialTicks);
            super.renderBottomBar(graphics);
            this.validate();
            this.layoutButtons(graphics);
            this.dimScrollPane.render(graphics, x, y, partialTicks);
            DrawUtil.drawLabel(graphics, this.currentLocation, this.width / 2, this.height, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 1.0f, 0xC0C0C0, 1.0f, 1.0, true);
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
                guibutton.render(graphics, x, y, 0.0f);
            }
            if (this.colorPickTooltip != null && this.colorPickRect.contains(x, y)) {
                MutableComponent tooltip = Constants.getStringTextComponent(this.colorPickTooltip);
                this.renderWrappedToolTip(graphics, this.getFontRenderer().split((FormattedText)tooltip, 200), x, y, this.getFontRenderer());
            }
            this.drawTitle(graphics);
            this.drawLogo(graphics);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    protected void drawWaypoint(GuiGraphics graphics, int x, int y) {
        DrawUtil.drawColoredImage(graphics.pose(), this.wpTexture, this.currentColor, 1.0f, x, y - this.wpTexture.getHeight() / 2, 0.0);
    }

    protected void drawColorPicker(GuiGraphics graphics, int x, int y, float size) {
        int sizeI = (int)size;
        graphics.fill(x - 1, y - 1, x + sizeI + 1, y + sizeI + 1, -6250336);
        float scale = size / (float)this.colorPickTexture.getWidth();
        if (this.colorPickRect.width != (double)size) {
            ((SimpleTextureImpl)this.colorPickTexture).resize(scale);
        }
        this.colorPickRect.setRect(x, y, size, size);
        DrawUtil.drawImage(graphics.pose(), this.colorPickTexture, x, y, false, 1.0f, 0.0);
    }

    protected void drawLabelAndField(GuiGraphics graphics, String label, TextBox field, int x, int y) {
        field.setX(x);
        field.setY(y);
        Font fr = this.getFontRenderer();
        int width = fr.width(label) + 4;
        graphics.drawString(this.getFontRenderer(), label, x - width, y + (field.getHeight() - 8) / 2, Color.cyan.getRGB());
        field.render(graphics, x, y, this.partialTicks);
    }

    protected void drawLabel(GuiGraphics graphics, String label, int x, int y) {
        graphics.drawString(this.getFontRenderer(), label, x, y, Color.cyan.getRGB());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
            case 257: {
                this.save();
                return true;
            }
            case 258: {
                this.validate();
                this.onTab();
                return true;
            }
        }
        for (EditBox editBox : this.fieldList) {
            editBox.keyPressed(keyCode, scanCode, modifiers);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.openedWithHotKey && this.isNew) {
            this.openedWithHotKey = false;
            return true;
        }
        for (EditBox editBox : this.fieldList) {
            editBox.charTyped(typedChar, keyCode);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.dimScrollPane.mouseReleased(mouseX, mouseY, mouseButton);
        for (EditBox editBox : this.fieldList) {
            editBox.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        for (EditBox editBox : this.fieldList) {
            editBox.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        this.checkColorPicker(mouseX, mouseY);
        this.dimScrollPane.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean mouseScrolled(double x, double y, double f, double scroll) {
        this.dimScrollPane.mouseScrolled(x, y, f, scroll);
        return super.mouseScrolled(x, y, f, scroll);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (EditBox editBox : this.fieldList) {
                editBox.mouseClicked(mouseX, mouseY, mouseButton);
            }
            this.checkColorPicker(mouseX, mouseY);
            this.dimScrollPane.mouseClicked(mouseX, mouseY, mouseButton);
            Button button = this.dimScrollPane.mouseClicked((int)mouseX, (int)mouseY, mouseButton);
            if (button != null) {
                this.actionPerformed(button);
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            this.setFormColor(this.colorPickTexture.getRGB(x, y));
        }
    }

    protected void setFormColor(Integer color) {
        this.currentColor = color;
        int[] c = RGB.ints(color);
        this.fieldR.setValue(Integer.toString(c[0]));
        this.fieldG.setValue(Integer.toString(c[1]));
        this.fieldB.setValue(Integer.toString(c[2]));
        this.updateWaypointFromForm();
    }

    protected void actionPerformed(net.minecraft.client.gui.components.Button guibutton) {
        if (this.dimButtonList.contains(guibutton)) {
            DimensionButton dimButton = (DimensionButton)guibutton;
            dimButton.toggle();
            this.updateWaypointFromForm();
        }
    }

    protected void setRandomColor() {
        int color = RGB.randomColor();
        this.editedWaypoint.setColor(color);
        this.setFormColor(this.editedWaypoint.getIconColor());
    }

    protected void onTab() {
        boolean focusNext = false;
        boolean foundFocus = false;
        for (TextBox field : this.fieldList) {
            if (focusNext) {
                field.setFocused(true);
                foundFocus = true;
                break;
            }
            if (!field.isFocused()) continue;
            field.setFocused(false);
            field.clamp();
            focusNext = true;
        }
        if (!foundFocus) {
            this.fieldList.get(0).setFocused(true);
        }
    }

    protected boolean validate() {
        boolean valid = true;
        if (this.fieldName != null) {
            boolean bl = valid = this.fieldName.hasMinLength() && Strings.isNotEmpty((CharSequence)this.fieldName.getValue());
        }
        if (valid && this.fieldY != null) {
            valid = this.fieldY.hasMinLength();
        }
        if (this.buttonSave != null) {
            this.buttonSave.setEnabled(valid && (this.isNew || !this.originalWaypoint.equals(this.editedWaypoint)));
        }
        return valid;
    }

    protected void remove() {
        WaypointStore.getInstance().remove(this.originalWaypoint, true);
        this.refreshAndClose(null);
    }

    protected void save() {
        if (!this.validate()) {
            return;
        }
        this.updateWaypointFromForm();
        WaypointStore.getInstance().remove(this.originalWaypoint, false);
        WaypointStore.getInstance().save(this.editedWaypoint, this.isNew);
        this.refreshAndClose(this.editedWaypoint);
    }

    protected void resetForm() {
        this.editedWaypoint = new ClientWaypointImpl((Waypoint)this.originalWaypoint);
        this.dimButtonList.clear();
        this.fieldList.clear();
        this.getRenderables().clear();
        this.init();
        this.validate();
    }

    protected void updateWaypointFromForm() {
        String dim;
        this.currentColor = RGB.toInteger(this.getSafeColorInt(this.fieldR), this.getSafeColorInt(this.fieldG), this.getSafeColorInt(this.fieldB));
        this.editedWaypoint.setColor(this.currentColor);
        this.fieldName.setTextColor(this.editedWaypoint.getSafeColor());
        ArrayList<String> dims = new ArrayList<String>();
        for (DimensionButton db : this.dimButtonList) {
            if (!db.getToggled().booleanValue()) continue;
            dims.add(db.dimension);
        }
        this.editedWaypoint.setDimensions(dims);
        this.editedWaypoint.setEnabled(this.buttonEnable.getToggled());
        this.editedWaypoint.setName(this.fieldName.getValue());
        String string = dim = this.originalWaypoint.getPos().getPrimaryDimension() != null ? this.originalWaypoint.getPos().getPrimaryDimension() : DimensionHelper.getDimKeyName((Entity)this.minecraft.player);
        if (dims.size() == 1 && !dims.getFirst().equals(this.originalWaypoint.getPrimaryDimension())) {
            this.editedWaypoint.setPrimaryDimension(dims.getFirst());
            dim = dims.getFirst();
            for (DimensionButton db : this.dimButtonList) {
                db.isPrimary = db.dimension.equals(dim);
            }
        }
        this.editedWaypoint.setLocation(this.getSafeCoordInt(this.fieldX), this.getSafeCoordInt(this.fieldY), this.getSafeCoordInt(this.fieldZ), dim);
    }

    protected int getSafeColorInt(TextBox field) {
        field.clamp();
        String text = field.getValue();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Math.max(0, Math.min(255, val));
    }

    protected int getSafeCoordInt(TextBox field) {
        String text = field.getValue();
        if (text == null || text.isEmpty() || text.equals("-")) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    protected void refreshAndClose(ClientWaypointImpl focusWaypoint) {
        if (returnDisplayStack != null && returnDisplayStack.peek() != null && returnDisplayStack.peek() instanceof LegacyWaypointManager) {
            ((LegacyWaypointManager)((Object)returnDisplayStack.peek())).setFocusWaypoint(focusWaypoint);
        }
        Fullscreen.state().requireRefresh();
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    class DimensionButton
    extends OnOffButton {
        public final String dimension;
        public boolean isPrimary;

        DimensionButton(WaypointEditor this$0, String dimension, String dimensionName, boolean toggled, boolean isPrimary) {
            super(String.format("%s: %s", dimensionName, Constants.getString("jm.common.on")), String.format("%s: %s", dimensionName, Constants.getString("jm.common.off")), toggled, Button.emptyPressable());
            this.dimension = dimension;
            this.isPrimary = isPrimary;
            this.setToggled(toggled);
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            if (this.isPrimary) {
                int leftX = this.getX() + 2;
                int rightX = this.getWidth() - 4;
                int topY = this.getY() + 2;
                int bottomY = this.getHeight() - 4 + topY;
                DrawUtil.drawRectangle(graphics, leftX, topY, rightX, 1.0, 0xC0C0C0, 0.5f);
                DrawUtil.drawRectangle(graphics, leftX, bottomY - 1, rightX, 1.0, 0xC0C0C0, 0.5f);
                DrawUtil.drawRectangle(graphics, leftX, topY + 1, 1.0, this.getHeight() - 6, 0xC0C0C0, 0.5f);
                DrawUtil.drawRectangle(graphics, this.getWidth() - 5 + leftX, topY + 1, 1.0, this.getHeight() - 6, 0xC0C0C0, 0.5f);
            }
        }
    }
}

