/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.ImagePopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupMenu;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class GroupSlot
extends ManagerSlot
implements SelectableParent {
    private final WaypointGroup group;
    private int width;
    private int height;
    boolean selected = false;
    private int x;
    private int y;
    private boolean isAll = false;
    private boolean isNative = false;
    private PopupMenu popupMenu;
    private ManagerSlot.ToolTipMeta tooltips;
    private LinearLayout layout = LinearLayout.horizontal();
    private StringWidget text;

    public GroupSlot(WaypointGroup group, int width, int height) {
        this.group = group;
        this.width = width;
        this.height = height;
        this.buildTooltips();
        this.testNativeGroup();
    }

    @Override
    public void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    @Override
    public void init() {
        Font font = Minecraft.getInstance().font;
        int count = this.group.getWaypointIds().size();
        String name = this.group.getName();
        this.text = new StringWidget((Component)Component.literal((String)String.format("%s (%s)", name, count)), Minecraft.getInstance().font);
        this.layout = LinearLayout.horizontal();
        this.layout.spacing(2);
        if (this.isNative) {
            this.layout.addChild((LayoutElement)new SpacerElement(12, 12));
        } else {
            ImagePopupButton deleteButton = (ImagePopupButton)this.layout.addChild(new ImagePopupButton<Tuple2>(12, 12, TextureCache.X_OUTLINE_SPRITE, ChatFormatting.RED.getColor(), Constants.getString("jm.waypoint.delete_group.label"), () -> new DeleteConfirmGroupPopup(this.group), this::deleteGroup));
            deleteButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.delete_group.label")));
        }
        if (this.isAll) {
            this.layout.addChild((LayoutElement)new SpacerElement(12, 12));
        } else {
            BasicImageButton editButton = (BasicImageButton)this.layout.addChild((LayoutElement)new BasicImageButton(12, 12, TextureCache.OPTIONS_SPRITE, this::editGroup, (Component)Component.translatable((String)"jm.waypoint.group.edit.label")), LayoutSettings::alignVerticallyMiddle);
            editButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit.label")));
        }
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)name), font.width("XXXXXXXXX"), font).alignLeft(), LayoutSettings.defaults().alignVerticallyMiddle().paddingLeft(1));
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)String.format("%s", count)), font.width("000"), font).alignRight(), LayoutSettings::alignVerticallyMiddle);
        this.repositionElements();
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    private void buildTooltips() {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(FormattedCharSequence.forward((String)this.group.getName(), (Style)Style.EMPTY.applyFormat(ChatFormatting.AQUA)));
        if (this.group.getDescription() != null) {
            tooltip.add(FormattedCharSequence.forward((String)this.group.getDescription(), (Style)Style.EMPTY.applyFormat(ChatFormatting.AQUA)));
        }
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.group.edit.waypoints", this.group.getWaypointIds().size()), (Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.group.edit.id", this.group.getGuid()), (Style)Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        this.tooltips = new ManagerSlot.ToolTipMeta(tooltip);
    }

    private void editGroup(Button button) {
        new EditGroupPopup((Component)Component.translatable((String)"jm.waypoint.group.edit.label"), this.group).display();
    }

    protected void deleteGroup(Tuple2<Boolean, Boolean> tuple2) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple2.a()).booleanValue()));
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        return false;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return new ArrayList();
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip(int mouseX, int mouseY) {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.visitWidgets(widget -> {
            Button button;
            if (widget instanceof Button && (button = (Button)widget).isHovered()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltips : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        boolean drawHovered = isMouseOver;
        this.x = x;
        this.y = y;
        this.width = rowWidth;
        this.height = itemHeight;
        this.layout.setX(x + 3);
        this.layout.setY(y + 2);
        Integer color = drawHovered ? backgroundHover : background;
        float alpha = drawHovered ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(graphics, x, y, rowWidth - 4, itemHeight, color, alpha);
        if (this.selected) {
            DrawUtil.drawRectangle(graphics, x, y, rowWidth - 4, itemHeight, backgroundHover, 1.0f);
        }
        this.layout.visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
        if (this.group.colorOverride()) {
            this.outline(graphics, x - 1, y - 1, rowWidth - 3, itemHeight + 1, this.group.getColor(), alpha * 2.0f);
        }
    }

    public void renderTransferStatus(GuiGraphics graphics, boolean transferable) {
        int color = transferable ? 65280 : 0xFF0000;
        DrawUtil.drawRectangle(graphics, this.x, this.y, this.width - 4, this.height, color, 0.4f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        long clickTime = Util.getMillis();
        boolean bl = this.doubleclick = clickTime - this.lastClickTime < 250L && this.lastClickButton == button;
        if (button == 1 || this.doubleclick) {
            if (this.doubleclick) {
                this.editGroup(null);
            }
            this.lastClickTime = clickTime;
            this.lastClickButton = button;
            return true;
        }
        this.selected = this.isMouseOver(mouseX, mouseY);
        this.lastClickTime = clickTime;
        this.lastClickButton = button;
        return this.selected;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public WaypointGroup getGroup() {
        return this.group;
    }

    private void testNativeGroup() {
        if (WaypointGroupStore.ALL.getGuid().equals(this.group.getGuid())) {
            this.isNative = true;
            this.isAll = true;
        } else if (WaypointGroupStore.TEMP.getGuid().equals(this.group.getGuid()) || WaypointGroupStore.DEFAULT.getGuid().equals(this.group.getGuid()) || WaypointGroupStore.DEATH.getGuid().equals(this.group.getGuid())) {
            this.isNative = true;
        }
    }

    @Override
    public void setSelected(DropDownItem button) {
        this.popupMenu.setSelected(button);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group.getName()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupSlot groupSlot = (GroupSlot)o;
        return Objects.equals(this.group.getGuid(), groupSlot.group.getGuid());
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }
}

