/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import java.util.ArrayList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.ServerOptionsManager;
import journeymap.common.Journeymap;
import journeymap.common.properties.MultiplayerCategory;
import journeymap.common.properties.MultiplayerProperties;
import journeymap.common.properties.ServerCategory;
import journeymap.common.properties.catagory.Category;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;

public class MultiplayerOptionsManager
extends ServerOptionsManager {
    MultiplayerProperties multiplayerProperties;

    public MultiplayerOptionsManager(Screen returnDisplay) {
        super(returnDisplay, Constants.getString("jm.options.multiplayer.title"), new ArrayList<Category>(ServerCategory.values));
    }

    @Override
    public void init() {
        super.init();
        if (!this.buttonServer.getMessage().getString().contains(ChatFormatting.STRIKETHROUGH.toString())) {
            this.buttonServer.setEnabled(true);
        }
        this.buttonMultiplayer.setEnabled(false);
    }

    @Override
    protected void requestInitData() {
        JourneymapClient.getInstance().getDispatcher().sendMultiplayerOptionsRequest();
    }

    public void setData(String payload) {
        try {
            this.multiplayerProperties = (MultiplayerProperties)new MultiplayerProperties().loadForClient(payload, false);
            this.slotMap.put(MultiplayerCategory.Multiplayer, this.multiplayerProperties);
            this.init();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting data", (Throwable)e);
        }
    }

    @Override
    protected void save() {
        JourneymapClient.getInstance().getDispatcher().sendMultiplayerOptionsSaveRequest(this.multiplayerProperties.toJsonString(false));
    }

    @Override
    protected List<CategorySlot> getCategorySlotList() {
        return OptionSlotFactory.getOptionSlots(this.getToolbars(), this.slotMap, !JourneymapClient.getInstance().getStateHandler().isExpandedRadarEnabled(), false);
    }
}

