/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Supplier;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ImagePopupButton<T>
extends PopupButton<T> {
    protected final WidgetSprites sprites;
    protected int color = -1;

    public ImagePopupButton(int width, int height, WidgetSprites sprites, String title, Supplier<PopupButtonScreen<T>> screen, PopupButtonScreen.OnClose<T> onClose) {
        this(width, height, sprites, null, title, screen, onClose);
    }

    public ImagePopupButton(int width, int height, WidgetSprites sprites, @Nullable Integer color, String title, Supplier<PopupButtonScreen<T>> screen, PopupButtonScreen.OnClose<T> onClose) {
        super(width, height, title, screen, onClose);
        if (color != null) {
            this.color = RGB.toInteger(RGB.floats(color, 255.0f));
        }
        this.sprites = sprites;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        ResourceLocation resourcelocation = this.sprites.get(this.isActive(), this.isHoveredOrFocused());
        Texture tex = TextureCache.getTexture(resourcelocation);
        RenderType renderType = JMRenderTypes.getIcon(tex);
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics.pose(), vertexBuilder, this.color, 1.0f, (double)this.getX(), (double)this.getY(), (double)this.getWidth(), (double)this.getHeight(), 0.0, false);
        buffers.endLastBatch();
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int color) {
    }
}

