/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUILegacy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollPane
extends ObjectSelectionList<ScrollPaneEntry> {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Button selected = null;
    private Integer frameColor = new Color(-6250336).getRGB();
    private Minecraft mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private int firstVisibleIndex;
    private int lastVisibleIndex;
    private boolean drawPartialScrollable = true;
    private boolean renderSolidBackground = false;
    private boolean renderDecorations = true;
    private boolean scrollVisible = true;
    protected boolean renderSelection;

    public ScrollPane(JmUILegacy parent, Minecraft mc, int width, int height, List<? extends Button> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, itemHeight + itemGap);
        for (Button button : items) {
            super.addEntry((AbstractSelectionList.Entry)new ScrollPaneEntry(this, this, button));
        }
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int getX() {
        return (int)this.origin.getX();
    }

    public int getY() {
        return (int)this.origin.getY();
    }

    public int getSlotHeight() {
        return this.height;
    }

    public void setDrawPartialScrollable(boolean value) {
        this.drawPartialScrollable = value;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.setRectangle(width, height, x, y);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
    }

    protected int getItemCount() {
        return super.getItemCount();
    }

    protected ScrollPaneEntry getEntry(int index) {
        return (ScrollPaneEntry)super.getEntry(index);
    }

    public boolean isSelectedItem(int i) {
        return super.isSelectedItem(i);
    }

    public Button mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (ScrollPaneEntry entry : super.children()) {
                Button item = entry.item;
                if (item == null || !this.inFullView(item)) continue;
                if (item.isHovered() && item.mouseClicked(mouseX, mouseY, mouseButton)) {
                    item.onPress();
                    return item;
                }
                item.clickScrollable(this.mc, mouseX, mouseY);
            }
        }
        return null;
    }

    public Button getButton(int mouseX, int mouseY) {
        for (ScrollPaneEntry entry : super.children()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item) || !item.isHovered() || !item.mouseOver(mouseX, mouseY)) continue;
            return item;
        }
        return null;
    }

    public void renderWidget(GuiGraphics graphics, int mX, int mY, float partialTicks) {
        this._mouseX = mX;
        this._mouseY = mY;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
        graphics.pose().pushPose();
        RenderWrapper.enableDepthTest();
        this.renderBackground(graphics);
        super.renderWidget(graphics, mX, mY, partialTicks);
        graphics.pose().popPose();
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected void renderBackground(GuiGraphics graphics) {
        int width = this.getWidth();
        float alpha = 0.4f;
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY(), width, this.paneHeight, Color.BLACK.getRGB(), this.renderSolidBackground ? 1.0f : alpha);
        boolean bl = this.scrollVisible = 0 < this.getMaxScroll();
        if (this.scrollVisible) {
            DrawUtil.drawRectangle(graphics, this.getX() + width - 6, super.getY(), 5.0, this.paneHeight, Color.BLACK.getRGB(), alpha);
        }
        if (this.showFrame) {
            alpha = 1.0f;
            DrawUtil.drawRectangle(graphics, this.getX() - 1, this.getY() - 1, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.getX() - 1, this.getY() + this.paneHeight, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.getX() - 1, this.getY() - 1, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, width + (this.scrollVisible ? 1 : 0) + this.getX(), this.getY() - 1, 1.0, this.paneHeight + 2, this.frameColor, alpha);
        }
    }

    public void renderItem(GuiGraphics graphics, int index, int y, int x, int l, int var6, int var7, float f) {
        if (this.firstVisibleIndex == -1) {
            this.firstVisibleIndex = index;
        }
        this.lastVisibleIndex = Math.max(this.lastVisibleIndex, index);
        int margin = 4;
        int itemX = this.getX() + 2;
        Button item = ((ScrollPaneEntry)super.getEntry((int)index)).item;
        item.setScrollablePosition(itemX, y);
        item.setScrollableWidth(this.paneWidth - 4);
        if (this.inFullView(item)) {
            item.drawScrollable(graphics, this.mc, this._mouseX, this._mouseY);
            item.renderSpecialDecoration(graphics, this._mouseX, this._mouseY, this.getX(), this.getY(), this.getWidth(), this.height);
        } else {
            int paneBottomY = this.getY() + this.paneHeight;
            int itemBottomY = y + item.getButtonHeight();
            Integer drawY = null;
            int yDiff = 0;
            if (y < this.getY() && itemBottomY > this.getY()) {
                drawY = this.getY();
                yDiff = drawY - y;
            } else if (y < paneBottomY && itemBottomY > paneBottomY) {
                drawY = y;
                yDiff = itemBottomY - paneBottomY;
            }
            if (drawY != null && this.drawPartialScrollable) {
                item.drawPartialScrollable(graphics, this.mc, itemX, drawY, item.getScrollableWidth(), item.getButtonHeight() - yDiff);
            }
        }
    }

    protected void renderSelection(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
        if (this.renderSelection) {
            super.renderSelection(guiGraphics, i, j, k, l, m);
        }
    }

    protected void renderDecorations(GuiGraphics graphics, int x, int y) {
        if (this.renderDecorations) {
            RenderWrapper.depthFunc(515);
            RenderWrapper.disableDepthTest();
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 0, 1);
            RenderWrapper.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex((float)super.getX(), (float)(super.getY() + 5), 0.0f).setColor(0, 0, 0, 0);
            buffer.addVertex((float)super.getRight(), (float)(super.getY() + 5), 0.0f).setColor(0, 0, 0, 0);
            buffer.addVertex((float)super.getRight(), (float)super.getY(), 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)super.getX(), (float)super.getY(), 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)super.getX(), (float)super.getBottom(), 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)super.getRight(), (float)super.getBottom(), 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)super.getRight(), (float)(super.getBottom() - 5), 0.0f).setColor(0, 0, 0, 0);
            buffer.addVertex((float)super.getX(), (float)(super.getBottom() - 5), 0.0f).setColor(0, 0, 0, 0);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.children().isEmpty()) {
            return false;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)super.getY()) {
                this.setScrollAmount(0.0);
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int i = super.getBottom() - super.getY();
                int j = Mth.clamp((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + mouseDY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean isScrollVisible() {
        return this.scrollVisible;
    }

    public boolean inFullView(Button item) {
        return item.getY() >= this.getY() && item.getY() + item.getButtonHeight() <= this.getY() + this.paneHeight;
    }

    protected int getScrollbarPosition() {
        return this.paneWidth + this.getX();
    }

    public void updateScrollingState(double xPos, double yPos, int button) {
        double rightX = this.getX() + this.getWidth() - 5;
        this.scrolling = button == 0 && xPos >= rightX && xPos < rightX + 10.0;
    }

    protected int getMaxPosition() {
        return super.getMaxPosition();
    }

    public int getWidth() {
        boolean scrollVisible = 0 < this.getMaxScroll();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(Font fr) {
        int fit = 0;
        for (ScrollPaneEntry entry : this.children()) {
            fit = Math.max(fit, entry.item.getFitWidth(fr));
        }
        return fit;
    }

    public int getMaxScroll() {
        return super.getMaxScroll();
    }

    public boolean isMouseOver(double posX, double posY) {
        int topY = this.getY();
        int bottomY = this.getY() + this.paneHeight;
        int leftX = this.getX();
        int rightX = this.getX() + this.getWidth();
        return posY >= (double)topY && posY <= (double)bottomY && posX >= (double)leftX && posX <= (double)rightX;
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        return Optional.empty();
    }

    public void mouseMoved(double mouseX, double mouseY) {
        for (ScrollPaneEntry entry : super.children()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item)) continue;
            item.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
    }

    public void setRenderDecorations(boolean value) {
        this.renderDecorations = value;
    }

    class ScrollPaneEntry
    extends ObjectSelectionList.Entry<ScrollPaneEntry> {
        private ScrollPane parent;
        private Button item;

        public ScrollPaneEntry(ScrollPane this$0, ScrollPane parent, Button item) {
            this.parent = parent;
            this.item = item;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int l, int var6, int var7, int p_230432_8_, boolean p_230432_9_, float f) {
            this.parent.renderItem(graphics, index, y, x, l, var6, var7, f);
        }

        public Component getNarration() {
            return Component.literal((String)"");
        }
    }
}

