/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import java.io.IOException;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.Texture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class SimpleTextureImpl
extends SimpleTexture
implements Texture {
    private final ResourceLocation location;
    private final Float2ObjectMap<Texture> scaledImageMap = new Float2ObjectOpenHashMap();
    private float alpha;
    private SimpleTexture.TextureImage textureData;
    private Integer renderWidth;
    private Integer renderHeight;

    public SimpleTextureImpl(ResourceLocation location) {
        super(location);
        this.location = location;
        this.textureData = super.getTextureImage(Minecraft.getInstance().getResourceManager());
    }

    @Override
    public int getWidth() {
        try {
            return this.renderWidth == null ? this.textureData.getImage().getWidth() : this.renderWidth.intValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHeight() {
        try {
            return this.renderHeight == null ? this.textureData.getImage().getHeight() : this.renderHeight.intValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDisplayWidth(int width) {
        this.renderWidth = width;
    }

    @Override
    public void setDisplayHeight(int height) {
        this.renderHeight = height;
    }

    public void resize(float scale) {
        try {
            NativeImage newImg = ImageUtil.getScaledImage(scale, this.textureData.getImage(), false);
            this.setNativeImage(newImg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        if (drawScale == 1.0f) {
            return this;
        }
        Texture scaledTexture = (Texture)this.scaledImageMap.get(drawScale);
        try {
            if (scaledTexture == null) {
                scaledTexture = new DynamicTextureImpl(ImageUtil.getScaledImage(drawScale, this.textureData.getImage(), false), drawScale);
                this.scaledImageMap.put(drawScale, (Object)scaledTexture);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return scaledTexture;
    }

    @Override
    public Integer getRGB(int x, int y) {
        int rgba = this.getNativeImage().getPixelRGBA(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    @Override
    public int getTextureId() {
        return super.getId();
    }

    @Override
    public boolean hasImage() {
        return this.textureData != null;
    }

    @Override
    public void remove() {
        this.close();
    }

    @Override
    public void setNativeImage(NativeImage image) {
        this.textureData.close();
        this.textureData = this.updateImage(Minecraft.getInstance().getResourceManager(), image);
    }

    public void close() {
        if (this.getNativeImage() != null) {
            this.scaledImageMap.values().forEach(Texture::remove);
            this.getNativeImage().close();
            this.textureData.close();
            this.releaseId();
            this.textureData = null;
        }
    }

    @Override
    public NativeImage getNativeImage() {
        try {
            return this.textureData.getImage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private SimpleTexture.TextureImage updateImage(ResourceManager pResourceManager, NativeImage nativeimage) {
        try {
            Resource resource = (Resource)pResourceManager.getResource(this.location).get();
            TextureMetadataSection texturemetadatasection = null;
            try {
                texturemetadatasection = resource.metadata().getSection((MetadataSectionSerializer)TextureMetadataSection.SERIALIZER).orElse(null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            SimpleTexture.TextureImage image = new SimpleTexture.TextureImage(texturemetadatasection, nativeimage);
            return image;
        }
        catch (IOException ioexception) {
            return new SimpleTexture.TextureImage(ioexception);
        }
    }

    @Override
    public void release() {
        super.releaseId();
    }
}

