/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.vertex.PoseStack;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointOrigin;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.phys.Vec3;

public abstract class WaypointRenderer {
    protected WaypointProperties waypointProperties;
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected EntityRenderDispatcher renderManager = this.minecraft.getEntityRenderDispatcher();

    protected WaypointRenderer() {
    }

    public abstract void render(PoseStack var1);

    protected boolean canDrawWaypoint(ClientWaypointImpl waypoint, String playerDim) {
        WaypointGroupImpl group = WaypointGroupStore.getInstance().get(waypoint.getGroupId());
        return (WaypointOrigin.EXTERNAL_FORCE.getValue().equals(waypoint.getOrigin()) || waypoint.isEnabled() && group != null && group.isEnabled() && JourneymapClient.getInstance().getWaypointProperties().beaconEnabled.get() != false && JourneymapClient.getInstance().getStateHandler().canShowInGameBeacons() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) && waypoint.getDimensions().contains(playerDim);
    }

    protected void renderWaypoint(ClientWaypointImpl waypoint, PoseStack poseStack, DrawStep.Pass pass, MultiBufferSource buffers) {
        if (pass == DrawStep.Pass.Tooltip) {
            return;
        }
        if (this.renderManager == null) {
            this.renderManager = this.minecraft.getEntityRenderDispatcher();
        }
        float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(true);
        long gameTime = this.minecraft.level.getGameTime();
        float fadeAlpha = 1.0f;
        Vec3 waypointVec = waypoint.getPosition().add(0.0, 0.118, 0.0);
        Vec3 playerVec = this.minecraft.player.position();
        double actualDistance = playerVec.distanceTo(waypointVec);
        int maxDistance = this.waypointProperties.maxDistance.get();
        int minDistance = this.waypointProperties.minDistance.get();
        float[] rgba = RGB.floats(waypoint.getRenderColor(), fadeAlpha * 0.4f);
        double viewX = this.renderManager.camera.getPosition().x();
        double viewY = this.renderManager.camera.getPosition().y();
        double viewZ = this.renderManager.camera.getPosition().z();
        double viewDistance = actualDistance;
        double maxRenderDistance = (Integer)this.minecraft.options.renderDistance().get() * 16;
        if (maxDistance > 0 && actualDistance > (double)maxDistance) {
            return;
        }
        if (waypoint.isDeathPoint() && this.waypointProperties.autoRemoveDeathpoints.get().booleanValue() && actualDistance < (double)this.waypointProperties.autoRemoveDeathpointDistance.get().intValue() && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing deathpoint " + String.valueOf(waypoint));
            WaypointStore.getInstance().remove(waypoint, true);
            return;
        }
        if (WaypointOrigin.TEMP.getValue().equals(waypoint.getOrigin()) && (actualDistance <= (double)this.waypointProperties.autoRemoveTempWaypoints.get().intValue() || actualDistance <= (double)(minDistance + 4)) && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing temp waypoint " + String.valueOf(waypoint));
            WaypointStore.getInstance().remove(waypoint, true);
        }
        if (minDistance > 0) {
            if ((int)actualDistance <= minDistance) {
                return;
            }
            if ((int)actualDistance <= minDistance + 4) {
                fadeAlpha = Math.min((float)(actualDistance - (double)minDistance) / 3.0f, 1.0f);
            }
        }
        if (viewDistance > maxRenderDistance) {
            Vec3 delta = waypointVec.subtract(playerVec).normalize();
            waypointVec = playerVec.add(delta.x * maxRenderDistance, delta.y * maxRenderDistance, delta.z * maxRenderDistance);
            viewDistance = maxRenderDistance;
        }
        double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
        double shiftX = waypointVec.x - viewX;
        double shiftY = waypointVec.y - viewY;
        double shiftZ = waypointVec.z - viewZ;
        this.render(poseStack, pass, buffers, waypoint, partialTicks, gameTime, rgba, fadeAlpha, shiftX, shiftY, shiftZ, playerVec, waypointVec, viewDistance, actualDistance, scale);
    }

    protected abstract void render(PoseStack var1, DrawStep.Pass var2, MultiBufferSource var3, ClientWaypointImpl var4, float var5, long var6, float[] var8, float var9, double var10, double var12, double var14, Vec3 var16, Vec3 var17, double var18, double var20, double var22);
}

