/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.FileHandler;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.texture.ImageUtil;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.ChunkPos;

public class RegionImageHandler {
    public static Set<String> getImageFilesForMapType(Minecraft minecraft, MapType mapType) {
        Set<String> set;
        block8: {
            File dir = FileHandler.getJMWorldDir(minecraft);
            String name = mapType.isUnderground() ? mapType.vSlice.toString() : mapType.name.name();
            Stream<Path> walk = Files.walk(Paths.get(dir.toURI()), new FileVisitOption[0]);
            try {
                set = walk.filter(f -> {
                    String path = f.toString();
                    return path.endsWith("png") && path.contains(name) && path.contains(FileHandler.getPathDimensionName(mapType.dimension));
                }).map(p -> p.getFileName().toString()).collect(Collectors.toSet());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Unable to get images:", t);
                    return new HashSet<String>();
                }
            }
            walk.close();
        }
        return set;
    }

    public static File getImageDir(RegionCoord rCoord, MapType mapType) {
        File dimDir = rCoord.dimDir.toFile();
        File subDir = null;
        subDir = mapType.isUnderground() ? new File(dimDir, Integer.toString(mapType.vSlice)) : new File(dimDir, mapType.name());
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        return subDir;
    }

    public static File getRegionImageFile(RegionCoord rCoord, MapType mapType) {
        return new File(RegionImageHandler.getImageDir(rCoord, mapType), rCoord.getFileName());
    }

    public static NativeImage readRegionImage(File regionFile) {
        if (regionFile.canRead()) {
            try {
                NativeImage image = RegionImageHandler.getImage(regionFile);
                return image;
            }
            catch (Exception e) {
                String error = "Region file produced error: " + String.valueOf(regionFile) + ": " + LogFormatter.toPartialString(e);
                Journeymap.getLogger().error(error);
            }
        }
        return null;
    }

    public static NativeImage getImage(File file) {
        try {
            FileInputStream is = new FileInputStream(file.getPath());
            return NativeImage.read((InputStream)is);
        }
        catch (IOException e) {
            String error = "Could not get image from file: " + String.valueOf(file) + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static synchronized NativeImage getMergedChunks(File worldDir, ChunkPos startCoord, ChunkPos endCoord, MapType mapType, Boolean useCache, NativeImage image, Integer imageWidth, Integer imageHeight, boolean allowNullImage, boolean showGrid) {
        int scale = 1;
        scale = Math.max(scale, 1);
        int initialWidth = Math.min(512, (endCoord.x - startCoord.x + 1) * 16 / scale);
        int initialHeight = Math.min(512, (endCoord.z - startCoord.z + 1) * 16 / scale);
        image = new NativeImage(initialWidth, initialHeight, false);
        RegionImageCache cache = RegionImageCache.INSTANCE;
        RegionCoord rc = null;
        NativeImage regionImage = null;
        int rx1 = RegionCoord.getRegionPos(startCoord.x);
        int rx2 = RegionCoord.getRegionPos(endCoord.x);
        int rz1 = RegionCoord.getRegionPos(startCoord.z);
        int rz2 = RegionCoord.getRegionPos(endCoord.z);
        boolean imageDrawn = false;
        for (int rx = rx1; rx <= rx2; ++rx) {
            for (int rz = rz1; rz <= rz2; ++rz) {
                rc = new RegionCoord(worldDir, rx, rz, mapType.dimension);
                regionImage = cache.getRegionImageSet(rc).getImage(mapType);
                if (regionImage == null) continue;
                int rminCx = Math.max(rc.getMinChunkX(), startCoord.x);
                int rminCz = Math.max(rc.getMinChunkZ(), startCoord.z);
                int rmaxCx = Math.min(rc.getMaxChunkX(), endCoord.x);
                int rmaxCz = Math.min(rc.getMaxChunkZ(), endCoord.z);
                int xoffset = rc.getMinChunkX() * 16;
                int yoffset = rc.getMinChunkZ() * 16;
                int sx1 = rminCx * 16 - xoffset;
                int sy1 = rminCz * 16 - yoffset;
                int sx2 = sx1 + (rmaxCx - rminCx + 1) * 16;
                int sy2 = sy1 + (rmaxCz - rminCz + 1) * 16;
                xoffset = startCoord.x * 16;
                yoffset = startCoord.z * 16;
                int dx1 = startCoord.x * 16 - xoffset;
                int dy1 = startCoord.z * 16 - yoffset;
                int dx2 = dx1 + (endCoord.x - startCoord.x + 1) * 16;
                int dy2 = dy1 + (endCoord.z - startCoord.z + 1) * 16;
                for (int x = 0; x < sx2; ++x) {
                    for (int y = 0; y < sy2; ++y) {
                        int pixel = regionImage.getPixelRGBA(x, y);
                        image.setPixelRGBA(x, y, pixel);
                    }
                }
                imageDrawn = true;
            }
        }
        if (imageDrawn && showGrid) {
            int color = mapType.isDay() ? RGB.toArbg(0, 0.25f) : RGB.toArbg(0x808080, 0.1f);
            for (int y = 0; y < initialHeight; y += 16) {
                for (int x = 0; x < initialWidth; ++x) {
                    image.blendPixel(x, y, color);
                }
            }
            for (int x = 0; x < initialWidth; x += 16) {
                for (int y = 0; y < initialHeight; ++y) {
                    image.blendPixel(x, y, color);
                }
            }
        }
        if (allowNullImage && !imageDrawn) {
            return null;
        }
        if (imageHeight != null && imageWidth != null && (initialHeight != imageHeight || initialWidth != imageWidth)) {
            return ImageUtil.getSizedImage(imageWidth, imageHeight, image, true);
        }
        return image;
    }

    public static File getBlank512x512ImageFile() {
        File dataDir = new File(FileHandler.MinecraftDirectory, Constants.DATA_DIR);
        File tmpFile = new File(dataDir, "blank512x512.png");
        if (!tmpFile.canRead()) {
            try (NativeImage image = new NativeImage(512, 512, false);){
                dataDir.mkdirs();
                image.writeToFile(tmpFile);
                image.fillRect(0, 0, 512, 512, 0);
                tmpFile.setReadOnly();
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Could not create blank temp file " + String.valueOf(tmpFile) + ": " + LogFormatter.toString(e));
            }
        }
        return tmpFile;
    }
}

