/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import java.util.ArrayList;
import java.util.HashMap;
import journeymap.client.JourneymapClientForge;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.event.ForgeChatEvents;
import journeymap.client.event.ForgeChunkEvents;
import journeymap.client.event.ForgeClientTickEvent;
import journeymap.client.event.ForgeHudOverlayEvents;
import journeymap.client.event.ForgeLoggedInEvent;
import journeymap.client.event.ForgeRenderLevelStageEvent;
import journeymap.client.event.ForgeScreenEvents;
import journeymap.client.event.ForgeWorldEvent;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraftforge.common.MinecraftForge;

public class ForgeEventHandlerManager {
    private static HashMap<Class<? extends EventHandler>, EventHandler> handlers = new HashMap();

    public static void registerHandlers() {
        ForgeEventHandlerManager.register(JourneymapClientForge.getInstance().getKeyEvents());
        ForgeEventHandlerManager.register(new ForgeChatEvents());
        ForgeEventHandlerManager.register(new ForgeHudOverlayEvents());
        ForgeEventHandlerManager.register(new ForgeWorldEvent());
        ForgeEventHandlerManager.register(new ForgeChunkEvents());
        ForgeEventHandlerManager.register(new ForgeClientTickEvent());
        ForgeEventHandlerManager.register(new ForgeRenderLevelStageEvent());
        ForgeEventHandlerManager.register(new ForgeLoggedInEvent());
        ForgeEventHandlerManager.register(new ForgeScreenEvents());
        ColorManager.INSTANCE.getDeclaringClass();
    }

    public static void unregisterAll() {
        ArrayList<Class<? extends EventHandler>> list = new ArrayList<Class<? extends EventHandler>>(handlers.keySet());
        for (Class<? extends EventHandler> handlerClass : list) {
            ForgeEventHandlerManager.unregister(handlerClass);
        }
    }

    public static void register(EventHandler handler) {
        Class<?> handlerClass = handler.getClass();
        if (handlers.containsKey(handlerClass)) {
            Journeymap.getLogger().warn("Handler already registered: " + handlerClass.getName());
            return;
        }
        try {
            MinecraftForge.EVENT_BUS.register((Object)handler);
            Journeymap.getLogger().debug("Handler registered: " + handlerClass.getName());
            handlers.put(handler.getClass(), handler);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(handlerClass.getName() + " registration FAILED: " + LogFormatter.toString(t));
        }
    }

    public static void unregister(Class<? extends EventHandler> handlerClass) {
        EventHandler handler = handlers.remove(handlerClass);
        if (handler != null) {
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)handler);
                Journeymap.getLogger().debug("Handler unregistered: " + handlerClass.getName());
            }
            catch (Throwable t) {
                Journeymap.getLogger().error(String.valueOf(handler) + " unregistration FAILED: " + LogFormatter.toString(t));
            }
        }
    }

    public static HashMap<Class<? extends EventHandler>, EventHandler> getHandlers() {
        return handlers;
    }

    public static interface EventHandler {
    }
}

