/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Since;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.BiomeColor;
import journeymap.client.cartography.color.BlockStateColor;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.FileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.model.BiomeMD;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ColorPalette {
    public static final String JSON_FILENAME = "colorpalette.json";
    public static final String VARIABLE = "var colorpalette=";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final double VERSION = 6.0;
    private static final Logger logger = Journeymap.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(HashBasedTable.class, (Object)new BlockStateSerializer()).registerTypeAdapter(HashBasedTable.class, (Object)new BlockStateDeserializer()).registerTypeAdapter(HashMap.class, (Object)new BiomeSerializer()).registerTypeAdapter(HashMap.class, (Object)new BiomeDeserializer()).create();
    @Since(value=3.0)
    double version;
    @Since(value=1.0)
    String name;
    @Since(value=1.0)
    String generated;
    @Since(value=5.49)
    @SerializedName(value="blockStateTable", alternate={"table"})
    HashBasedTable<String, String, BlockStateColor> blockStateTable;
    @Since(value=6.0)
    HashMap<String, BiomeColor> biomeTable;
    private transient File origin;
    private transient boolean dirty;
    private transient Type type;

    ColorPalette() {
        this.blockStateTable = HashBasedTable.create((int)Block.BLOCK_STATE_REGISTRY.size(), (int)16);
        this.biomeTable = new HashMap();
    }

    private ColorPalette(Type type) {
        this.version = 6.0;
        this.name = Constants.getString("jm.colorpalette.file_title");
        this.generated = String.format("Generated using %s for %s on %s", JourneymapClient.MOD_NAME, "1.21", new Date());
        this.type = type;
        this.blockStateTable = HashBasedTable.create((int)Block.BLOCK_STATE_REGISTRY.size(), (int)16);
        this.biomeTable = new HashMap();
    }

    public static ColorPalette getWorldColorPalette() {
        ColorPalette palette;
        File worldPaletteFile = ColorPalette.getWorldPaletteFile();
        if (worldPaletteFile.canRead() && (palette = ColorPalette.loadFromFile(worldPaletteFile, Type.World)) != null) {
            if (palette.version < 6.0) {
                logger.warn(String.format("Existing world color palette is obsolete. Required version: %s.  Found version: %s", 6.0, palette.version));
            } else {
                return palette;
            }
        }
        return null;
    }

    public static ColorPalette getGlobalColorPalette() {
        File globalPaletteFile = ColorPalette.getGlobalPaletteFile();
        if (globalPaletteFile.canRead()) {
            ColorPalette palette = ColorPalette.loadFromFile(globalPaletteFile, Type.Global);
            if (palette != null && palette.version != 6.0) {
                logger.warn(String.format("Existing color palette is unusable. Required version: %s.  Found version: %s", 6.0, palette.version));
                globalPaletteFile.renameTo(new File(globalPaletteFile.getParentFile(), globalPaletteFile.getName() + ".v" + palette.version));
                return null;
            }
            return palette;
        }
        return null;
    }

    public static ColorPalette create(Type type) {
        long start = System.currentTimeMillis();
        ColorPalette palette = null;
        try {
            palette = new ColorPalette(type);
            String nameInfo = "Default Palette";
            if (type != Type.Default) {
                palette.origin = type == Type.Global ? ColorPalette.getGlobalPaletteFile() : ColorPalette.getWorldPaletteFile();
                nameInfo = palette.getOrigin().toString();
            }
            long elapsed = System.currentTimeMillis() - start;
            logger.info(String.format("Color palette file generated for %d blockstates in %dms for: %s", palette.stateCount(), elapsed, nameInfo));
            return palette;
        }
        catch (Exception e) {
            logger.error("Couldn't create ColorPalette: " + LogFormatter.toString(e));
            return null;
        }
    }

    private static File getWorldPaletteFile() {
        Minecraft mc = Minecraft.getInstance();
        return new File(FileHandler.getJMWorldDir(mc), JSON_FILENAME);
    }

    private static File getGlobalPaletteFile() {
        return new File(FileHandler.getJourneyMapDir(), JSON_FILENAME);
    }

    private static ColorPalette loadFromFile(File file, Type type) {
        String jsonString = null;
        try {
            jsonString = Files.toString((File)file, (Charset)UTF8).replaceFirst(VARIABLE, "");
            ColorPalette palette = (ColorPalette)GSON.fromJson(jsonString, ColorPalette.class);
            palette.type = type;
            palette.origin = file;
            ColorPalette.setVanillaFlags(palette);
            return palette;
        }
        catch (Throwable e) {
            ChatLog.announceError(Constants.getString("jm.colorpalette.file_error", file.getPath()));
            try {
                file.renameTo(new File(file.getParentFile(), file.getName() + ".bad"));
            }
            catch (Exception e2) {
                logger.error("Couldn't rename bad palette file: " + String.valueOf(e2));
            }
            return null;
        }
    }

    private static void setVanillaFlags(ColorPalette palette) {
        if (palette.getType() == Type.Default) {
            return;
        }
        Set<BlockMD> blockMDs = BlockMD.getAllMinecraft();
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        if (defaultPalette == null) {
            return;
        }
        for (BlockMD blockMD : blockMDs) {
            BlockStateColor defaultBSC;
            BlockStateColor blockStateColor = palette.getBlockStateColor(blockMD);
            if (blockStateColor == null || (defaultBSC = defaultPalette.getBlockStateColor(blockMD)) == null) continue;
            EnumSet<BlockFlag> enumSet = blockStateColor.flags = defaultBSC.flags == null ? null : defaultBSC.flags.clone();
            if (blockStateColor.alpha.floatValue() != 1.0f && blockStateColor.flags != null && !blockStateColor.flags.contains((Object)BlockFlag.Transparency)) {
                blockStateColor.alpha = Float.valueOf(1.0f);
            }
            palette.dirty = true;
        }
    }

    private String substituteValueInContents(String contents, String key, Object ... params) {
        String token = String.format("\\$%s\\$", key);
        return contents.replaceAll(token, Matcher.quoteReplacement(Constants.getString(key, params)));
    }

    public void setBlockStateColor(String blockId, String blockState, int color, float alpha, EnumSet<BlockFlag> flags) {
        BlockStateColor blockStateColor = new BlockStateColor(blockId, blockState, RGB.toHexString(color), Float.valueOf(alpha), flags);
        this.blockStateTable.put((Object)blockId, (Object)blockState, (Object)blockStateColor);
        this.dirty = true;
    }

    public boolean hasBlockStateColor(BlockMD blockMD) {
        return this.blockStateTable.contains((Object)BlockMD.getBlockId(blockMD), (Object)BlockMD.getBlockStateId(blockMD));
    }

    public boolean hasBlockId(String blockId) {
        return this.blockStateTable.containsRow((Object)blockId);
    }

    public BlockStateColor getBlockStateColor(BlockMD blockMD) {
        return (BlockStateColor)this.blockStateTable.get((Object)BlockMD.getBlockId(blockMD), (Object)BlockMD.getBlockStateId(blockMD));
    }

    public BlockStateColor getBlockStateColor(String blockId, String blockState) {
        return (BlockStateColor)this.blockStateTable.get((Object)blockId, (Object)blockState);
    }

    public void addBlockStateColor(BlockMD blockMD, Integer color) {
        BlockStateColor blockStateColor = new BlockStateColor(blockMD, color);
        this.blockStateTable.put((Object)blockStateColor.block, (Object)blockStateColor.state, (Object)blockStateColor);
        this.dirty = true;
    }

    public void setBiomeColor(String biomeId, int grassColor, int fogColor, int foliageColor, int waterColor) {
        BiomeColor biomeColor = new BiomeColor(biomeId, (Integer)grassColor, (Integer)fogColor, (Integer)foliageColor, (Integer)waterColor);
        this.biomeTable.put(biomeId, biomeColor);
        this.dirty = true;
    }

    public boolean hasBiomeColor(BiomeMD biomeMD) {
        return this.biomeTable.containsKey(biomeMD.getBiomeId());
    }

    public boolean hasBiomeId(String biomeId) {
        return this.biomeTable.containsKey(biomeId);
    }

    public BiomeColor getBiomeColor(BiomeMD biomeMD) {
        return this.biomeTable.get(biomeMD.getBiomeId());
    }

    public BiomeColor getBiomeColor(String biomeId) {
        return this.biomeTable.get(biomeId);
    }

    public void addBiomeColor(BiomeMD biomeMD, Integer grassColor, Integer fogColor, Integer foliageColor, Integer waterColor) {
        BiomeColor biomeColor = new BiomeColor(biomeMD, grassColor, fogColor, foliageColor, waterColor);
        this.biomeTable.put(biomeColor.biome, biomeColor);
        this.dirty = true;
    }

    public void copyBlockFromPalette(ColorPalette other, String blockId) {
        for (Map.Entry entry : other.blockStateTable.row((Object)blockId).entrySet()) {
            this.blockStateTable.put((Object)blockId, (Object)((String)entry.getKey()), (Object)new BlockStateColor((BlockStateColor)entry.getValue()));
        }
        this.dirty = true;
    }

    public void copyBiomeFromPalette(ColorPalette other, String biomeId) {
        if (other.biomeTable.containsKey(biomeId)) {
            this.biomeTable.put(biomeId, new BiomeColor(other.biomeTable.get(biomeId)));
        }
        this.dirty = true;
    }

    public void copyAllFromPalette(ColorPalette other) {
        for (Table.Cell cell : other.blockStateTable.cellSet()) {
            BlockStateColor blockStateColor = new BlockStateColor((BlockStateColor)cell.getValue());
            this.blockStateTable.put((Object)((String)cell.getRowKey()), (Object)((String)cell.getColumnKey()), (Object)blockStateColor);
        }
        for (Map.Entry entry : other.biomeTable.entrySet()) {
            BiomeColor biomeColor = new BiomeColor((BiomeColor)entry.getValue());
            this.biomeTable.put((String)entry.getKey(), biomeColor);
        }
        this.dirty = true;
    }

    public void copyExistingFromPalette(ColorPalette other) {
        for (Table.Cell cell : other.blockStateTable.cellSet()) {
            if (!this.blockStateTable.contains(cell.getRowKey(), cell.getColumnKey())) continue;
            BlockStateColor blockStateColor = new BlockStateColor((BlockStateColor)cell.getValue());
            this.blockStateTable.put((Object)((String)cell.getRowKey()), (Object)((String)cell.getColumnKey()), (Object)blockStateColor);
        }
        for (Map.Entry entry : other.biomeTable.entrySet()) {
            if (!this.biomeTable.containsKey(entry.getKey())) continue;
            BiomeColor biomeColor = new BiomeColor((BiomeColor)entry.getValue());
            this.biomeTable.put((String)entry.getKey(), biomeColor);
        }
        this.dirty = true;
    }

    public void copyNonExistingFromPalette(ColorPalette other) {
        for (Table.Cell cell : other.blockStateTable.cellSet()) {
            if (this.blockStateTable.contains(cell.getRowKey(), cell.getColumnKey())) continue;
            BlockStateColor blockStateColor = new BlockStateColor((BlockStateColor)cell.getValue());
            this.blockStateTable.put((Object)((String)cell.getRowKey()), (Object)((String)cell.getColumnKey()), (Object)blockStateColor);
        }
        for (Map.Entry entry : other.biomeTable.entrySet()) {
            if (this.biomeTable.containsKey(entry.getKey())) continue;
            BiomeColor biomeColor = new BiomeColor((BiomeColor)entry.getValue());
            this.biomeTable.put((String)entry.getKey(), biomeColor);
        }
        this.dirty = true;
    }

    public void removeBlock(String blockId) {
        if (this.blockStateTable.rowKeySet().removeIf(id -> id.equals(blockId))) {
            this.dirty = true;
        }
    }

    public void removeBiome(String biomeId) {
        if (this.biomeTable.keySet().removeIf(id -> id.equals(biomeId))) {
            this.dirty = true;
        }
    }

    public void applyColor(BlockMD blockMD) {
        BlockStateColor blockStateColor = this.getBlockStateColor(blockMD);
        if (blockStateColor == null) {
            return;
        }
        blockMD.setFlags(blockStateColor.flags);
        blockMD.setAlpha(blockStateColor.alpha != null ? blockStateColor.alpha.floatValue() : 1.0f);
        int color = RGB.hexToInt(blockStateColor.color);
        blockMD.setColor(color);
    }

    public void applyColor(BiomeMD biomeMD) {
        BiomeColor biomeColor = this.getBiomeColor(biomeMD);
        if (biomeColor == null) {
            return;
        }
        biomeMD.setGrassColor(RGB.hexToInt(biomeColor.grassColor));
        biomeMD.setFogColor(RGB.hexToInt(biomeColor.fogColor));
        biomeMD.setFoliageColor(RGB.hexToInt(biomeColor.foliageColor));
        biomeMD.setWaterColor(RGB.hexToInt(biomeColor.waterColor));
    }

    public void writeToFile() {
        if (this.type == Type.Default || !this.dirty) {
            return;
        }
        if (this.blockStateTable.isEmpty() && this.biomeTable.isEmpty()) {
            this.deleteFile();
            return;
        }
        try {
            Files.write((CharSequence)(VARIABLE + GSON.toJson((Object)this)), (File)this.origin, (Charset)UTF8);
            this.dirty = false;
        }
        catch (Exception e) {
            logger.error(String.format("Can't save color palette file %s: %s", this.origin, LogFormatter.toString(e)));
        }
    }

    public void deleteFile() {
        if (this.type == Type.Default) {
            return;
        }
        try {
            this.origin.delete();
        }
        catch (Exception e) {
            logger.error(String.format("Can't delete color palette file %s: %s", this.origin, LogFormatter.toString(e)));
        }
    }

    public void clear() {
        this.blockStateTable.clear();
        this.biomeTable.clear();
        this.dirty = true;
        this.writeToFile();
    }

    public boolean hasBlockStateColors() {
        return !this.blockStateTable.isEmpty();
    }

    public boolean hasBiomeColors() {
        return !this.biomeTable.isEmpty();
    }

    public File getOrigin() throws IOException {
        return this.origin.getCanonicalFile();
    }

    public Type getType() {
        return this.type;
    }

    public double getVersion() {
        return this.version;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int blockCount() {
        return this.blockStateTable.rowKeySet().size();
    }

    public int stateCount() {
        return this.blockStateTable.cellSet().size();
    }

    public int biomeCount() {
        return this.biomeTable.size();
    }

    public Set<String> getAllBlocks() {
        return this.blockStateTable.rowKeySet();
    }

    public Map<String, BlockStateColor> getAllStates(String blockId) {
        return new TreeMap<String, BlockStateColor>(this.blockStateTable.row((Object)blockId));
    }

    public boolean hasModdedBlockOrBiome() {
        if (!this.blockStateTable.rowKeySet().stream().allMatch(block -> block.startsWith("minecraft:"))) {
            return true;
        }
        return !this.biomeTable.keySet().stream().allMatch(block -> block.startsWith("minecraft:"));
    }

    public Set<String> getAllBiomes() {
        return this.biomeTable.keySet();
    }

    public String toString() {
        return String.format("ColorPalette[blocks: %d, states: %d, biomes: %d]", this.blockCount(), this.stateCount(), this.biomeCount());
    }

    public static enum Type {
        Default,
        Global,
        World;

    }

    private static class BlockStateSerializer
    implements JsonSerializer<HashBasedTable<String, String, BlockStateColor>> {
        private BlockStateSerializer() {
        }

        public JsonElement serialize(HashBasedTable<String, String, BlockStateColor> src, java.lang.reflect.Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonTable = new JsonObject();
            for (String blockId : src.rowKeySet().stream().sorted().toList()) {
                String[] resource = blockId.split(":");
                String mod = resource[0];
                String block = resource[1];
                JsonObject jsonMod = null;
                boolean isVanilla = mod.equals("minecraft");
                if (!jsonTable.has(mod)) {
                    jsonMod = new JsonObject();
                    jsonTable.add(mod, (JsonElement)jsonMod);
                } else {
                    jsonMod = jsonTable.getAsJsonObject(mod);
                }
                JsonObject jsonBlock = null;
                if (!jsonMod.has(block)) {
                    jsonBlock = new JsonObject();
                    jsonMod.add(block, (JsonElement)jsonBlock);
                } else {
                    jsonBlock = jsonMod.getAsJsonObject(block);
                }
                for (String stateId : src.row((Object)blockId).keySet().stream().sorted().toList()) {
                    BlockStateColor blockStateColor = (BlockStateColor)src.get((Object)blockId, (Object)stateId);
                    if (blockStateColor == null) continue;
                    JsonArray bscArray = new JsonArray();
                    bscArray.add((JsonElement)new JsonPrimitive(blockStateColor.color));
                    if (blockStateColor.alpha.floatValue() != 1.0f) {
                        bscArray.add((JsonElement)new JsonPrimitive((Number)blockStateColor.alpha));
                    }
                    if (!isVanilla && blockStateColor.flags != null && !blockStateColor.flags.isEmpty()) {
                        bscArray.add(GSON.toJsonTree(blockStateColor.flags, new TypeToken<EnumSet<BlockFlag>>(this){}.getType()));
                    }
                    jsonBlock.add(stateId, (JsonElement)bscArray);
                }
            }
            return jsonTable;
        }
    }

    private static class BlockStateDeserializer
    implements JsonDeserializer<HashBasedTable<String, String, BlockStateColor>> {
        private BlockStateDeserializer() {
        }

        public HashBasedTable<String, String, BlockStateColor> deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashBasedTable result = HashBasedTable.create((int)Block.BLOCK_STATE_REGISTRY.size(), (int)16);
            JsonObject jsonTable = json.getAsJsonObject();
            for (Map.Entry jsonMod : jsonTable.entrySet()) {
                String modId = (String)jsonMod.getKey();
                boolean isVanilla = modId.equals("minecraft");
                for (Map.Entry jsonBlock : ((JsonElement)jsonMod.getValue()).getAsJsonObject().entrySet()) {
                    String blockId = modId + ":" + (String)jsonBlock.getKey();
                    for (Map.Entry jsonState : ((JsonElement)jsonBlock.getValue()).getAsJsonObject().entrySet()) {
                        String blockStateId = (String)jsonState.getKey();
                        JsonArray bscArray = ((JsonElement)jsonState.getValue()).getAsJsonArray();
                        String color = bscArray.get(0).getAsString();
                        float alpha = 1.0f;
                        EnumSet flags = null;
                        if (bscArray.size() == 3) {
                            alpha = bscArray.get(1).getAsFloat();
                            flags = isVanilla ? null : (EnumSet)GSON.fromJson(bscArray.get(2), new TypeToken<EnumSet<BlockFlag>>(this){}.getType());
                        } else if (bscArray.size() == 2) {
                            try {
                                alpha = bscArray.get(1).getAsFloat();
                            }
                            catch (Exception e) {
                                flags = isVanilla ? null : (EnumSet)GSON.fromJson(bscArray.get(1), new TypeToken<EnumSet<BlockFlag>>(this){}.getType());
                            }
                        }
                        BlockStateColor blockStateColor = new BlockStateColor(blockId, blockStateId, color, Float.valueOf(alpha), flags);
                        result.put((Object)blockId, (Object)blockStateId, (Object)blockStateColor);
                    }
                }
            }
            return result;
        }
    }

    private static class BiomeSerializer
    implements JsonSerializer<HashMap<String, BiomeColor>> {
        private BiomeSerializer() {
        }

        public JsonElement serialize(HashMap<String, BiomeColor> src, java.lang.reflect.Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonTable = new JsonObject();
            for (String biomeId : src.keySet().stream().sorted().toList()) {
                String[] resource = biomeId.split(":");
                String mod = resource[0];
                String biome = resource[1];
                JsonObject jsonMod = null;
                if (!jsonTable.has(mod)) {
                    jsonMod = new JsonObject();
                    jsonTable.add(mod, (JsonElement)jsonMod);
                } else {
                    jsonMod = jsonTable.getAsJsonObject(mod);
                }
                BiomeColor biomeColor = src.get(biomeId);
                if (biomeColor == null) continue;
                JsonArray bcArray = new JsonArray();
                bcArray.add((JsonElement)new JsonPrimitive(biomeColor.grassColor));
                bcArray.add((JsonElement)new JsonPrimitive(biomeColor.fogColor));
                bcArray.add((JsonElement)new JsonPrimitive(biomeColor.foliageColor));
                bcArray.add((JsonElement)new JsonPrimitive(biomeColor.waterColor));
                jsonMod.add(biome, (JsonElement)bcArray);
            }
            return jsonTable;
        }
    }

    private static class BiomeDeserializer
    implements JsonDeserializer<HashMap<String, BiomeColor>> {
        private BiomeDeserializer() {
        }

        public HashMap<String, BiomeColor> deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<String, BiomeColor> result = new HashMap<String, BiomeColor>();
            JsonObject jsonTable = json.getAsJsonObject();
            for (Map.Entry jsonMod : jsonTable.entrySet()) {
                String modId = (String)jsonMod.getKey();
                for (Map.Entry jsonBiome : ((JsonElement)jsonMod.getValue()).getAsJsonObject().entrySet()) {
                    String biomeId = modId + ":" + (String)jsonBiome.getKey();
                    JsonArray bcArray = ((JsonElement)jsonBiome.getValue()).getAsJsonArray();
                    if (bcArray.size() < 4) continue;
                    String grassColor = bcArray.get(0).getAsString();
                    String fogColor = bcArray.get(1).getAsString();
                    String foliageColor = bcArray.get(2).getAsString();
                    String waterColor = bcArray.get(3).getAsString();
                    BiomeColor biomeColor = new BiomeColor(biomeId, grassColor, fogColor, foliageColor, waterColor);
                    result.put(biomeId, biomeColor);
                }
            }
            return result;
        }
    }
}

