/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import journeymap.client.JourneymapClient;
import journeymap.client.event.ForgeEventHandlerManager;
import journeymap.client.event.ForgeKeyEvents;
import journeymap.common.Journeymap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="journeymap")
public class JourneymapClientForge {
    private final ForgeKeyEvents keyEvents;
    private final JourneymapClient client;
    static JourneymapClientForge instance;

    public JourneymapClientForge() {
        instance = this;
        this.client = new JourneymapClient();
        this.keyEvents = new ForgeKeyEvents();
        this.client.setKeyEvents(this.keyEvents);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadCompleteEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeKeyEvents::onKeyRegisterEvent);
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        this.client.commonSetup();
    }

    public void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Journeymap Initializing");
            ForgeEventHandlerManager.registerHandlers();
            this.client.init();
        });
    }

    public void loadCompleteEvent(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Journeymap PostInit");
            this.client.postInit();
        });
    }

    public static JourneymapClientForge getInstance() {
        return instance;
    }

    public ForgeKeyEvents getKeyEvents() {
        return this.keyEvents;
    }
}

