/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.damagesource;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypes;

public interface EpicFightDamageSources {
    public static EpicFightDamageSources of(Level level) {
        return () -> level;
    }

    public static EpicFightDamageSource copy(DamageSource damageSource) {
        return new EpicFightDamageSource(damageSource);
    }

    default public EpicFightDamageSource shockwave(LivingEntity owner) {
        Holder<DamageType> damageType = this.getDamageTypeHolder(EpicFightDamageTypes.SHOCKWAVE);
        return new EpicFightDamageSource(damageType, (Entity)owner, (Entity)owner, null);
    }

    default public EpicFightDamageSource witherBeam(LivingEntity owner) {
        Holder<DamageType> damageType = this.getDamageTypeHolder(EpicFightDamageTypes.WITHER_BEAM);
        EpicFightDamageSource damageSource = new EpicFightDamageSource(damageType, (Entity)owner, (Entity)owner, null);
        damageSource.addRuntimeTag((ResourceKey<DamageType>)DamageTypes.f_268515_);
        return damageSource;
    }

    default public EpicFightDamageSource trident(Entity owner, Entity causingEntity) {
        return EpicFightDamageSources.copy(this.getDamageSources().m_269525_(owner, causingEntity));
    }

    default public EpicFightDamageSource mobAttack(LivingEntity owner) {
        return EpicFightDamageSources.copy(this.getDamageSources().m_269333_(owner));
    }

    default public EpicFightDamageSource playerAttack(Player owner) {
        return EpicFightDamageSources.copy(this.getDamageSources().m_269075_(owner));
    }

    default public EpicFightDamageSource enderDragonBreath(LivingEntity owner, Entity causingEntity) {
        EpicFightDamageSource damageSource = EpicFightDamageSources.copy(this.getDamageSources().m_269104_((Entity)owner, causingEntity));
        damageSource.addRuntimeTag((ResourceKey<DamageType>)DamageTypes.f_268515_);
        return damageSource;
    }

    default public DamageSources getDamageSources() {
        return this.getLevel().m_269111_();
    }

    default public Holder<DamageType> getDamageTypeHolder(ResourceKey<DamageType> key) {
        return this.getLevel().m_9598_().m_175515_(Registries.f_268580_).m_246971_(key);
    }

    public Level getLevel();
}

