/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.capabilities.item.Style;

public class TridentCapability
extends RangedWeaponCapability {
    private List<AnimationProvider<?>> attackMotion = List.of(Animations.TRIDENT_AUTO1, Animations.TRIDENT_AUTO2, Animations.TRIDENT_AUTO3, Animations.SPEAR_DASH, Animations.SPEAR_ONEHAND_AIR_SLASH);
    private List<AnimationProvider<?>> mountAttackMotion = List.of(Animations.SPEAR_MOUNT_ATTACK);

    public TridentCapability(CapabilityItem.Builder builder) {
        super(builder);
    }

    @Override
    public Style getStyle(LivingEntityPatch<?> entitypatch) {
        return CapabilityItem.Styles.ONE_HAND;
    }

    @Override
    public SoundEvent getHitSound() {
        return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
    }

    @Override
    public HitParticleType getHitParticle() {
        return (HitParticleType)((Object)EpicFightParticles.HIT_BLADE.get());
    }

    @Override
    public Collider getWeaponCollider() {
        return ColliderPreset.SPEAR;
    }

    @Override
    public List<AnimationProvider<?>> getAutoAttckMotion(PlayerPatch<?> playerpatch) {
        return this.attackMotion;
    }

    @Override
    public List<AnimationProvider<?>> getMountAttackMotion() {
        return this.mountAttackMotion;
    }

    @Override
    @Nullable
    public Skill getInnateSkill(PlayerPatch<?> playerpatch, ItemStack itemstack) {
        if (EnchantmentHelper.m_44932_((ItemStack)itemstack) > 0) {
            return EpicFightSkills.TSUNAMI;
        }
        if (EnchantmentHelper.m_44936_((ItemStack)itemstack)) {
            return EpicFightSkills.WRATHFUL_LIGHTING;
        }
        if (EnchantmentHelper.m_44928_((ItemStack)itemstack) > 0) {
            return EpicFightSkills.EVERLASTING_ALLEGIANCE;
        }
        return null;
    }
}

