/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class RangedWeaponCapability
extends CapabilityItem {
    protected Map<LivingMotion, AnimationProvider<?>> rangeAnimationModifiers;
    protected CapabilityItem.ZoomInType zoomInType;

    protected RangedWeaponCapability(CapabilityItem.Builder builder) {
        super(builder);
        Builder rangedBuilder = (Builder)builder;
        this.rangeAnimationModifiers = rangedBuilder.rangeAnimationModifiers;
        this.zoomInType = rangedBuilder.zoomInType;
    }

    @Override
    public void setConfigFileAttribute(double armorNegation1, double impact1, int maxStrikes1, double armorNegation2, double impact2, int maxStrikes2) {
        this.addStyleAttributes(CapabilityItem.Styles.RANGED, armorNegation1, impact1, maxStrikes1);
    }

    @Override
    public Map<LivingMotion, AnimationProvider<?>> getLivingMotionModifier(LivingEntityPatch<?> playerdata, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.rangeAnimationModifiers;
        }
        return super.getLivingMotionModifier(playerdata, hand);
    }

    @Override
    public boolean availableOnHorse() {
        return true;
    }

    @Override
    public boolean canBePlacedOffhand() {
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CapabilityItem.ZoomInType getZoomInType() {
        return this.zoomInType;
    }

    public static class Builder
    extends CapabilityItem.Builder {
        private Map<LivingMotion, AnimationProvider<?>> rangeAnimationModifiers;
        private CapabilityItem.ZoomInType zoomInType = CapabilityItem.ZoomInType.USE_TICK;

        protected Builder() {
            this.category = CapabilityItem.WeaponCategories.RANGED;
            this.constructor = RangedWeaponCapability::new;
            this.rangeAnimationModifiers = Maps.newHashMap();
        }

        public Builder addAnimationsModifier(LivingMotion livingMotion, AnimationProvider<?> animations) {
            this.rangeAnimationModifiers.put(livingMotion, animations);
            return this;
        }

        public Builder zoomInType(CapabilityItem.ZoomInType zoomInType) {
            this.zoomInType = zoomInType;
            return this;
        }
    }
}

