/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BerserkerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("fdc09ee8-fcfc-11eb-9a03-0242ac130003");
    private float speedBonus;
    private float damageBonus;

    public BerserkerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.speedBonus = parameters.m_128457_("speed_bonus");
        this.damageBonus = parameters.m_128457_("damage_bonus");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.m_21223_();
            float maxHealth = player.m_21233_();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * this.speedBonus * 0.01f;
            float attackSpeed = event.getAttackSpeed();
            event.setAttackSpeed(Math.min(5.0f, attackSpeed * (1.0f + lostHealthPercentage)));
        });
        listener.addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.m_21223_();
            float maxHealth = player.m_21233_();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * this.damageBonus * 0.01f;
            float attackDamage = event.getDamage();
            event.setDamage(attackDamage * (1.0f + lostHealthPercentage));
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        Player player = (Player)container.getExecuter().getOriginal();
        float health = player.m_21223_();
        float maxHealth = player.m_21233_();
        return maxHealth - health > 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        Player player = (Player)container.getExecuter().getOriginal();
        float health = player.m_21223_();
        float maxHealth = player.m_21233_();
        float lostHealthPercentage = (maxHealth - health) / maxHealth;
        lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f);
        guiGraphics.drawString(gui.font, String.format("%.0f%%", Float.valueOf(lostHealthPercentage)), x + 4.0f, y + 6.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.1f", Float.valueOf(this.speedBonus)));
        list.add(String.format("%.1f", Float.valueOf(this.damageBonus)));
        return list;
    }
}

