/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.guard;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class GuardSkill
extends Skill {
    protected static final UUID EVENT_UUID = UUID.fromString("b422f7a0-f378-11eb-9a03-0242ac130003");
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions;
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> advancedGuardMotions;
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardBreakMotions;
    protected float penalizer;

    public static Builder createGuardBuilder() {
        return new Builder().setCategory(SkillCategories.GUARD).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA).addGuardMotion(CapabilityItem.WeaponCategories.AXE, (item, player) -> Animations.SWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.UCHIGATANA, (item, player) -> Animations.UCHIGATANA_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.TWO_HAND ? Animations.SPEAR_GUARD_HIT : null).addGuardMotion(CapabilityItem.WeaponCategories.SWORD, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.ONE_HAND ? Animations.SWORD_GUARD_HIT : Animations.SWORD_DUAL_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addGuardBreakMotion(CapabilityItem.WeaponCategories.AXE, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.UCHIGATANA, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.SWORD, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED);
    }

    public GuardSkill(Builder builder) {
        super(builder);
        this.guardMotions = builder.guardMotions;
        this.advancedGuardMotions = builder.advancedGuardMotions;
        this.guardBreakMotions = builder.guardBreakMotions;
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.penalizer = parameters.m_128457_("penalizer");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, BlockType.GUARD) && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, BlockType.GUARD) && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {
            ServerPlayer serverplayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY_RESTORE_COUNTER.get(), Integer.valueOf(serverplayer.f_19797_), serverplayer);
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), Float.valueOf(0.0f), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((Player)container.getExecuter().getOriginal()).m_6117_() && this.guardMotions.containsKey(container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory())) {
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                Minecraft mc = Minecraft.m_91087_();
                ControllEngine.setKeyBind(mc.f_91066_.f_92091_, false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7655_());
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, BlockType.GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6117_() && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    viewVector = viewVector.m_82492_(0.0, viewVector.f_82480_, 0.0).m_82541_();
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    Object patt10093$temp = event.getDamageSource();
                    if (patt10093$temp instanceof EpicFightDamageSource) {
                        EpicFightDamageSource epicfightDamageSource = (EpicFightDamageSource)((Object)((Object)patt10093$temp));
                        if (epicfightDamageSource.m_269533_(EpicFightDamageType.GUARD_PUNCTURE)) {
                            return;
                        }
                        impact = epicfightDamageSource.getImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, false);
                }
            }
        }, 1);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource = (DamageSource)event.getDamageSource();
        if (this.isBlockableSource(damageSource, advanced)) {
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ServerPlayer serveerPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((HitParticleType)((Object)EpicFightParticles.HIT_BLUNT.get())).spawnParticleWithArgument(serveerPlayer.m_284548_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serveerPlayer, damageSource.m_7640_());
            Entity entity = damageSource.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)livingEntity) * 0.1f;
            }
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue() + this.getPenalizer(itemCapability);
            float consumeAmount = penalty * impact;
            boolean canAfford = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill(this, Skill.Resource.STAMINA, consumeAmount);
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), Float.valueOf(penalty), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            BlockType blockType = canAfford ? BlockType.GUARD : BlockType.GUARD_BREAK;
            StaticAnimation animation = this.getGuardMotion((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent((PlayerPatch<?>)event.getPlayerPatch(), event, advanced);
        }
    }

    public void dealEvent(PlayerPatch<?> playerpatch, HurtEvent.Pre event, boolean advanced) {
        Entity directEntity;
        LivingEntityPatch entitypatch;
        event.setCanceled(true);
        event.setResult(AttackResult.ResultType.BLOCKED);
        LivingEntityPatch attackerpatch = EpicFightCapabilities.getEntityPatch(((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class);
        if (attackerpatch != null) {
            attackerpatch.setLastAttackEntity((Entity)playerpatch.getOriginal());
        }
        if ((entitypatch = EpicFightCapabilities.getEntityPatch(directEntity = ((DamageSource)event.getDamageSource()).m_7640_(), LivingEntityPatch.class)) != null) {
            entitypatch.onAttackBlocked((DamageSource)event.getDamageSource(), playerpatch);
        }
    }

    protected float getPenalizer(CapabilityItem itemCapability) {
        return this.penalizer;
    }

    protected Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> getGuradMotionMap(BlockType blockType) {
        switch (blockType) {
            case GUARD_BREAK: {
                return this.guardBreakMotions;
            }
            case GUARD: {
                return this.guardMotions;
            }
            case ADVANCED_GUARD: {
                return this.advancedGuardMotions;
            }
        }
        throw new IllegalArgumentException("unsupported block type " + blockType);
    }

    protected boolean isHoldingWeaponAvailable(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, BlockType blockType) {
        StaticAnimation anim = itemCapability.getGuardMotion(this, blockType, playerpatch);
        if (anim != null) {
            return true;
        }
        Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions = this.getGuradMotionMap(blockType);
        if (!guardMotions.containsKey(itemCapability.getWeaponCategory())) {
            return false;
        }
        Object motion = guardMotions.get(itemCapability.getWeaponCategory()).apply(itemCapability, playerpatch);
        return motion != null;
    }

    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, BlockType blockType) {
        StaticAnimation animation = itemCapability.getGuardMotion(this, blockType, playerpatch);
        if (animation != null) {
            return animation;
        }
        return (StaticAnimation)this.getGuradMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch);
    }

    @Override
    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient() && !((Player)container.getExecuter().getOriginal()).m_6117_()) {
            int hitTick;
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue();
            if (penalty > 0.0f && ((Player)container.getExecuter().getOriginal()).f_19797_ - (hitTick = ((Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY_RESTORE_COUNTER.get())).intValue()) > 40) {
                container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), Float.valueOf(0.0f), (ServerPlayer)container.getExecuter().getOriginal());
            }
        } else {
            container.getExecuter().resetActionTick();
        }
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 1);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        return !executer.isInAir() && !executer.getEntityState().hurt() && executer.getEntityState().canUseSkill() && executer.isBattleMode();
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(EpicFightDamageType.PARTIAL_DAMAGE) && !damageSource.m_269533_(DamageTypeTags.f_268490_) && !damageSource.m_269533_(DamageTypeTags.f_268524_) && !damageSource.m_269533_(DamageTypeTags.f_268415_) && !damageSource.m_276093_(DamageTypes.f_268515_) && !damageSource.m_269533_(DamageTypeTags.f_268745_);
    }

    @Override
    public boolean shouldDraw(SkillContainer container) {
        return ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue() > 0.0f;
    }

    @Override
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(EpicFightSkills.GUARD.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        guiGraphics.drawString(gui.font, String.format("x%.1f", container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())), x, y + 6.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @Override
    public List<WeaponCategory> getAvailableWeaponCategories() {
        return List.copyOf(this.guardMotions.keySet());
    }

    @Override
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.m_237115_((String)"skill.epicfight.guard.consume.tooltip"), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }

    protected boolean isAdvancedGuard() {
        return false;
    }

    public static class Builder
    extends Skill.Builder<GuardSkill> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions = Maps.newHashMap();
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> advancedGuardMotions = Maps.newHashMap();
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardBreakMotions = Maps.newHashMap();

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder addGuardMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation> function) {
            this.guardMotions.put(weaponCategory, function);
            return this;
        }

        public Builder addAdvancedGuardMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?> function) {
            this.advancedGuardMotions.put(weaponCategory, function);
            return this;
        }

        public Builder addGuardBreakMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation> function) {
            this.guardBreakMotions.put(weaponCategory, function);
            return this;
        }
    }

    public static enum BlockType {
        GUARD_BREAK,
        GUARD,
        ADVANCED_GUARD;

    }
}

