/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.IdMapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.RegistryManager;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.utils.ClearableIdMapper;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillDataKeys;

public class SkillDataKey<T> {
    private static final HashMultimap<Class<?>, SkillDataKey<?>> SKILL_DATA_KEYS = HashMultimap.create();
    private static final ResourceLocation CLASS_TO_DATA_KEYS = new ResourceLocation("epicfight", "classtodatakeys");
    private static final ResourceLocation DATA_KEY_TO_ID = new ResourceLocation("epicfight", "datakeytoid");
    private final BiConsumer<ByteBuf, T> encoder;
    private final Function<ByteBuf, T> decoder;
    private final T defaultValue;
    private final boolean syncronizeTrackingPlayers;

    public static SkillDataKeyCallbacks getRegistryCallback() {
        return SkillDataKeyCallbacks.INSTANCE;
    }

    public static SkillDataKey<Integer> createIntKey(int defaultValue, boolean syncronizeTrackingPlayers, Class<?> ... skillClass) {
        return SkillDataKey.createSkillDataKey((buffer, val) -> buffer.writeInt(val.intValue()), buffer -> buffer.readInt(), defaultValue, syncronizeTrackingPlayers, skillClass);
    }

    public static SkillDataKey<Float> createFloatKey(float defaultValue, boolean syncronizeTrackingPlayers, Class<?> ... skillClass) {
        return SkillDataKey.createSkillDataKey((buffer, val) -> buffer.writeFloat(val.floatValue()), buffer -> Float.valueOf(buffer.readFloat()), Float.valueOf(defaultValue), syncronizeTrackingPlayers, skillClass);
    }

    public static SkillDataKey<Double> createDoubleKey(double defaultValue, boolean syncronizeTrackingPlayers, Class<?> ... skillClass) {
        return SkillDataKey.createSkillDataKey((buffer, val) -> buffer.writeDouble(val.doubleValue()), buffer -> buffer.readDouble(), defaultValue, syncronizeTrackingPlayers, skillClass);
    }

    public static SkillDataKey<Boolean> createBooleanKey(boolean defaultValue, boolean syncronizeTrackingPlayers, Class<?> ... skillClass) {
        return SkillDataKey.createSkillDataKey((buffer, val) -> buffer.writeBoolean(val.booleanValue()), buffer -> buffer.readBoolean(), defaultValue, syncronizeTrackingPlayers, skillClass);
    }

    public static SkillDataKey<Vec3f> createVector3fKey(Vec3f defaultValue, boolean syncronizeTrackingPlayers, Class<?> ... skillClass) {
        return SkillDataKey.createSkillDataKey((buffer, val) -> {
            buffer.writeFloat(val.x);
            buffer.writeFloat(val.y);
            buffer.writeFloat(val.z);
        }, buffer -> new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), defaultValue, syncronizeTrackingPlayers, skillClass);
    }

    public static SkillDataKey<Vec3> createVector3dKey(Vec3 defaultValue, boolean syncronizeTrackingPlayers, Class<?> ... skillClass) {
        return SkillDataKey.createSkillDataKey((buffer, val) -> {
            buffer.writeDouble(val.f_82479_);
            buffer.writeDouble(val.f_82480_);
            buffer.writeDouble(val.f_82481_);
        }, buffer -> new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), defaultValue, syncronizeTrackingPlayers, skillClass);
    }

    public static <T> SkillDataKey<T> createSkillDataKey(BiConsumer<ByteBuf, T> encoder, Function<ByteBuf, T> decoder, T defaultValue, boolean syncronizeTrackingPlayers, Class<?> ... skillClass) {
        SkillDataKey<T> key = new SkillDataKey<T>(encoder, decoder, defaultValue, syncronizeTrackingPlayers);
        for (Class<?> cls : skillClass) {
            SKILL_DATA_KEYS.put(cls, key);
        }
        return key;
    }

    public static IdMapper<SkillDataKey<?>> getIdMap() {
        return (IdMapper)SkillDataKeys.REGISTRY.get().getSlaveMap(DATA_KEY_TO_ID, IdMapper.class);
    }

    public static Map<Class<?>, Set<SkillDataKey<?>>> getSkillDataKeyMap() {
        return (Map)SkillDataKeys.REGISTRY.get().getSlaveMap(CLASS_TO_DATA_KEYS, Map.class);
    }

    public static SkillDataKey<Object> byId(int id) {
        return (SkillDataKey)SkillDataKey.getIdMap().m_7942_(id);
    }

    public SkillDataKey(BiConsumer<ByteBuf, T> encoder, Function<ByteBuf, T> decoder, T defaultValue, boolean syncronizeTrackingPlayers) {
        this.encoder = encoder;
        this.decoder = decoder;
        this.defaultValue = defaultValue;
        this.syncronizeTrackingPlayers = syncronizeTrackingPlayers;
    }

    public T readFromBuffer(ByteBuf buffer) {
        return this.decoder.apply(buffer);
    }

    public void writeToBuffer(ByteBuf buffer, T value) {
        this.encoder.accept(buffer, (ByteBuf)value);
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public int getId() {
        return SkillDataKey.getIdMap().m_7447_((Object)this);
    }

    public boolean syncronizeTrackingPlayers() {
        return this.syncronizeTrackingPlayers;
    }

    private static class SkillDataKeyCallbacks
    implements IForgeRegistry.BakeCallback<SkillDataKey<?>>,
    IForgeRegistry.CreateCallback<SkillDataKey<?>>,
    IForgeRegistry.ClearCallback<SkillDataKey<?>> {
        static final SkillDataKeyCallbacks INSTANCE = new SkillDataKeyCallbacks();

        private SkillDataKeyCallbacks() {
        }

        public void onBake(IForgeRegistryInternal<SkillDataKey<?>> owner, RegistryManager stage) {
            ClearableIdMapper skillDataKeyMap = (ClearableIdMapper)((Object)owner.getSlaveMap(DATA_KEY_TO_ID, ClearableIdMapper.class));
            owner.forEach(arg_0 -> ((ClearableIdMapper)skillDataKeyMap).m_122667_(arg_0));
            Map skillDataKeys = (Map)owner.getSlaveMap(CLASS_TO_DATA_KEYS, Map.class);
            SkillManager.getSkillRegistry().forEach(skill -> {
                Class<?> skillClass = skill.getClass();
                HashSet dataKeySet = Sets.newHashSet();
                skillDataKeys.put(skillClass, dataKeySet);
                do {
                    if (!SKILL_DATA_KEYS.containsKey(skillClass)) continue;
                    dataKeySet.addAll(SKILL_DATA_KEYS.get(skillClass));
                } while (Skill.class.isAssignableFrom(skillClass = skillClass.getSuperclass()));
            });
        }

        public void onCreate(IForgeRegistryInternal<SkillDataKey<?>> owner, RegistryManager stage) {
            owner.setSlaveMap(CLASS_TO_DATA_KEYS, (Object)Maps.newHashMap());
            owner.setSlaveMap(DATA_KEY_TO_ID, new ClearableIdMapper(owner.getKeys().size()));
        }

        public void onClear(IForgeRegistryInternal<SkillDataKey<?>> owner, RegistryManager stage) {
            ((Map)owner.getSlaveMap(CLASS_TO_DATA_KEYS, Map.class)).clear();
            ((ClearableIdMapper)((Object)owner.getSlaveMap(DATA_KEY_TO_ID, ClearableIdMapper.class))).clear();
        }
    }
}

