/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

public class SPSpawnData {
    private final int entityId;
    private final FriendlyByteBuf buffer;

    public SPSpawnData() {
        this.entityId = 0;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
    }

    public SPSpawnData(int entityId) {
        this.entityId = entityId;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public static SPSpawnData fromBytes(FriendlyByteBuf buf) {
        SPSpawnData msg = new SPSpawnData(buf.readInt());
        while (buf.isReadable()) {
            msg.buffer.writeByte((int)buf.readByte());
        }
        return msg;
    }

    public static void toBytes(SPSpawnData msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        while (msg.buffer.isReadable()) {
            buf.writeByte((int)msg.buffer.readByte());
        }
    }

    public static void handle(SPSpawnData msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            EntityPatch entitypatch;
            Minecraft mc = Minecraft.m_91087_();
            Entity entity = mc.f_91074_.m_9236_().m_6815_(msg.entityId);
            if (entity != null && (entitypatch = (EntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null)) != null) {
                entitypatch.processSpawnData((ByteBuf)msg.getBuffer());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

