/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public class SPChangeGamerule {
    private final SynchronizedGameRules gamerule;
    private final int gameruleId;
    private final Object object;

    public SPChangeGamerule() {
        this.gamerule = null;
        this.gameruleId = -1;
        this.object = 0;
    }

    public SPChangeGamerule(SynchronizedGameRules gamerule, Object object) {
        this.gamerule = gamerule;
        this.gameruleId = gamerule.ordinal();
        this.object = object;
    }

    public static SPChangeGamerule fromBytes(FriendlyByteBuf buf) {
        int id = buf.readInt();
        SynchronizedGameRules gamerule = SynchronizedGameRules.values()[id];
        Object obj = gamerule.decoder.apply((ByteBuf)buf);
        return new SPChangeGamerule(gamerule, obj);
    }

    public static void toBytes(SPChangeGamerule msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.gameruleId);
        msg.gamerule.encoder.accept((ByteBuf)buf, msg.object);
    }

    public static void handle(SPChangeGamerule msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> msg.gamerule.setRule.accept((Level)Minecraft.m_91087_().f_91073_, msg.object));
        ctx.get().setPacketHandled(true);
    }

    public static enum SynchronizedGameRules {
        HAS_FALL_ANIMATION(level -> level.m_46469_().m_46207_(EpicFightGamerules.HAS_FALL_ANIMATION), (level, value) -> ((GameRules.BooleanValue)level.m_46469_().m_46170_(EpicFightGamerules.HAS_FALL_ANIMATION)).m_46246_(((Boolean)value).booleanValue(), null), (buf, val) -> buf.writeBoolean(((Boolean)val).booleanValue()), ByteBuf::readBoolean),
        WEIGHT_PENALTY(level -> level.m_46469_().m_46215_(EpicFightGamerules.WEIGHT_PENALTY), (level, value) -> ((GameRules.IntegerValue)level.m_46469_().m_46170_(EpicFightGamerules.WEIGHT_PENALTY)).m_46314_(value.toString()), (buf, val) -> buf.writeInt(((Integer)val).intValue()), ByteBuf::readInt),
        DIABLE_ENTITY_UI(level -> level.m_46469_().m_46207_(EpicFightGamerules.DISABLE_ENTITY_UI), (level, value) -> ((GameRules.BooleanValue)level.m_46469_().m_46170_(EpicFightGamerules.DISABLE_ENTITY_UI)).m_46246_(((Boolean)value).booleanValue(), null), (buf, val) -> buf.writeBoolean(((Boolean)val).booleanValue()), ByteBuf::readBoolean),
        CAN_SWITCH_COMBAT(level -> level.m_46469_().m_46207_(EpicFightGamerules.CAN_SWITCH_COMBAT), (level, value) -> ((GameRules.BooleanValue)level.m_46469_().m_46170_(EpicFightGamerules.CAN_SWITCH_COMBAT)).m_46246_(((Boolean)value).booleanValue(), null), (buf, val) -> buf.writeBoolean(((Boolean)val).booleanValue()), ByteBuf::readBoolean),
        STIFF_COMBO_ATTACKS(level -> level.m_46469_().m_46207_(EpicFightGamerules.STIFF_COMBO_ATTACKS), (level, value) -> ((GameRules.BooleanValue)level.m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46246_(((Boolean)value).booleanValue(), null), (buf, val) -> buf.writeBoolean(((Boolean)val).booleanValue()), ByteBuf::readBoolean),
        NO_MOBS_IN_BOSSFIGHT(level -> level.m_46469_().m_46207_(EpicFightGamerules.NO_MOBS_IN_BOSSFIGHT), (level, value) -> ((GameRules.BooleanValue)level.m_46469_().m_46170_(EpicFightGamerules.NO_MOBS_IN_BOSSFIGHT)).m_46246_(((Boolean)value).booleanValue(), null), (buf, val) -> buf.writeBoolean(((Boolean)val).booleanValue()), ByteBuf::readBoolean),
        INITIAL_PLAYER_MODE(level -> level.m_46469_().m_46215_(EpicFightGamerules.INITIAL_PLAYER_MODE), (level, value) -> ((GameRules.IntegerValue)level.m_46469_().m_46170_(EpicFightGamerules.INITIAL_PLAYER_MODE)).m_46314_(value.toString()), (buf, val) -> buf.writeInt(((Integer)val).intValue()), ByteBuf::readInt);

        public Function<Level, Object> getRule;
        public BiConsumer<Level, Object> setRule;
        public BiConsumer<ByteBuf, Object> encoder;
        public Function<ByteBuf, Object> decoder;

        private SynchronizedGameRules(Function<Level, Object> getRule, BiConsumer<Level, Object> setRule, BiConsumer<ByteBuf, Object> encoder, Function<ByteBuf, Object> decoder) {
            this.getRule = getRule;
            this.setRule = setRule;
            this.encoder = encoder;
            this.decoder = decoder;
        }
    }
}

