/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.gameasset;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;

public class ColliderPreset
implements PreparableReloadListener {
    private static final BiMap<ResourceLocation, Collider> PRESETS = HashBiMap.create();
    public static final Collider DAGGER = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dagger"), new MultiOBBCollider(3, 0.4, 0.4, 0.6, 0.0, 0.0, -0.1));
    public static final Collider DUAL_DAGGER_DASH = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dual_dagger_dash"), new OBBCollider(0.8, 0.5, 1.0, 0.0, 1.0, -0.6));
    public static final Collider BIPED_BODY_COLLIDER = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "biped_body_collider"), new MultiOBBCollider(new OBBCollider(0.8, 0.5, 1.0, 0.0, 1.0, -0.6), new OBBCollider(0.8, 0.5, 1.0, 0.0, 1.0, -0.6)));
    public static final Collider DRAGON_BODY = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dragon_body"), new OBBCollider(2.0, 1.5, 4.0, 0.0, 1.5, -0.5));
    public static final Collider DRAGON_LEG = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dragon_leg"), new MultiOBBCollider(3, 0.8, 1.6, 0.8, 0.0, -0.6, 0.7));
    public static final Collider DUAL_SWORD = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dual_sword"), new OBBCollider(0.8, 0.5, 1.0, 0.0, 0.5, -1.0));
    public static final Collider DUAL_SWORD_DASH = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dual_sword_dash"), new OBBCollider(0.8, 0.5, 1.0, 0.0, 1.0, -1.0));
    public static final Collider BATTOJUTSU = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "battojutsu"), new OBBCollider(3.0, 0.4, 1.5, 0.0, 1.2, -1.0));
    public static final Collider BATTOJUTSU_DASH = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "battojutsu_dash"), new MultiOBBCollider(new OBBCollider(0.7, 0.7, 1.0, 0.0, 1.0, -1.0), new OBBCollider(0.7, 0.7, 1.0, 0.0, 1.0, -1.0), new OBBCollider(0.7, 0.7, 1.0, 0.0, 1.0, -1.0), new OBBCollider(0.7, 0.7, 1.0, 0.0, 1.0, -1.0), new OBBCollider(1.5, 0.7, 1.0, 0.0, 1.0, -1.0)));
    public static final Collider FIST = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "fist"), new MultiOBBCollider(3, 0.4, 0.4, 0.4, 0.0, 0.0, 0.0));
    public static final Collider GREATSWORD = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "greatsword"), new MultiOBBCollider(3, 0.5, 0.8, 1.0, 0.0, 0.0, -1.0));
    public static final Collider HEAD = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "head"), new OBBCollider(0.4, 0.4, 0.4, 0.0, 0.0, -0.3));
    public static final Collider HEADBUTT_RAVAGER = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "headbutt_ravager"), new OBBCollider(0.8, 0.8, 0.8, 0.0, 0.0, -0.3));
    public static final Collider UCHIGATANA = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "uchigatana"), new MultiOBBCollider(5, 0.4, 0.4, 0.7, 0.0, 0.0, -0.7));
    public static final Collider TACHI = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "tachi"), new MultiOBBCollider(3, 0.4, 0.4, 0.95, 0.0, 0.0, -0.95));
    public static final Collider SWORD = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "sword"), new MultiOBBCollider(3, 0.4, 0.4, 0.7, 0.0, 0.0, -0.35));
    public static final Collider LONGSWORD = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "longsword"), new MultiOBBCollider(3, 0.4, 0.4, 0.8, 0.0, 0.0, -0.75));
    public static final Collider SPEAR = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "spear"), new MultiOBBCollider(3, 0.6, 0.6, 1.0, 0.0, 0.0, -1.0));
    public static final Collider SPIDER = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "spider"), new OBBCollider(0.8, 0.8, 0.8, 0.0, 0.0, -0.4));
    public static final Collider TOOLS = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "tools"), new MultiOBBCollider(3, 0.4, 0.4, 0.55, 0.0, 0.0, -0.25));
    public static final Collider ENDERMAN_LIMB = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "enderman_limb"), new OBBCollider(0.4, 0.8, 0.4, 0.0, 0.0, 0.0));
    public static final Collider GOLEM_SMASHDOWN = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "golem_smashdown"), new MultiOBBCollider(3, 0.75, 0.5, 0.5, 0.6, 0.5, 0.0));
    public static final Collider GOLEM_SWING_ARM = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "golem_swing_arm"), new MultiOBBCollider(2, 0.6, 0.9, 0.6, 0.0, 0.0, 0.0));
    public static final Collider FIST_FIXED = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "fist_fixed"), new OBBCollider(0.4, 0.4, 0.5, 0.0, 1.25, -0.85));
    public static final Collider DUAL_SWORD_AIR_SLASH = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dual_sword_air_slash"), new OBBCollider(0.8, 0.4, 1.0, 0.0, 0.5, -0.5));
    public static final Collider DUAL_DAGGER_AIR_SLASH = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "dual_dagger_air_slash"), new OBBCollider(0.8, 0.4, 0.75, 0.0, 0.5, -0.5));
    public static final Collider WITHER_CHARGE = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "wither_charge"), new MultiOBBCollider(5, 0.7, 0.9, 0.7, 0.0, 1.0, -0.35));
    public static final Collider VEX_CHARGE = ColliderPreset.registerCollider(new ResourceLocation("epicfight", "vex_charge"), new MultiOBBCollider(3, 0.4, 0.4, 0.95, 0.0, 1.0, -0.85));

    public static Collider registerCollider(ResourceLocation rl, Collider collider) {
        if (PRESETS.containsKey((Object)rl)) {
            throw new IllegalStateException("Collider named " + rl + " already registered.");
        }
        PRESETS.put((Object)rl, (Object)collider);
        return collider;
    }

    public static Set<Map.Entry<ResourceLocation, Collider>> entries() {
        return Collections.unmodifiableSet(PRESETS.entrySet());
    }

    public static ResourceLocation getKey(Collider collider) {
        return (ResourceLocation)PRESETS.inverse().get((Object)collider);
    }

    public static Collider get(ResourceLocation rl) {
        return (Collider)PRESETS.get((Object)rl);
    }

    public static Collider deserializeSimpleCollider(CompoundTag tag) throws IllegalArgumentException {
        int number = tag.m_128451_("number");
        if (number < 1) {
            throw new IllegalArgumentException("Datapack deserialization error: the number of colliders must bigger than 0!");
        }
        ListTag sizeVector = tag.m_128437_("size", 6);
        ListTag centerVector = tag.m_128437_("center", 6);
        if (sizeVector.size() != 3) {
            throw new IllegalArgumentException("The size list tag must consist of three double elements.");
        }
        if (centerVector.size() != 3) {
            throw new IllegalArgumentException("The center list tag must consist of three double elements.");
        }
        double sizeX = sizeVector.m_128772_(0);
        double sizeY = sizeVector.m_128772_(1);
        double sizeZ = sizeVector.m_128772_(2);
        double centerX = centerVector.m_128772_(0);
        double centerY = centerVector.m_128772_(1);
        double centerZ = centerVector.m_128772_(2);
        if (sizeX < 0.0 || sizeY < 0.0 || sizeZ < 0.0 || sizeX == 0.0 && sizeY == 0.0 && sizeZ == 0.0) {
            throw new IllegalArgumentException("Datapack deserialization error: the size of the collider must be non-negative value!");
        }
        if (number == 1) {
            return new OBBCollider(sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
        }
        return new MultiOBBCollider(number, sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> {}, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
    }
}

