/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import io.netty.util.internal.StringUtil;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PlayerName
extends Condition.EntityPatchCondition {
    private String name;

    public PlayerName read(CompoundTag tag) {
        if (!tag.m_128441_("name") || StringUtil.isNullOrEmpty((String)tag.m_128461_("name"))) {
            throw new IllegalArgumentException("Undefined name");
        }
        this.name = tag.m_128461_("name");
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", this.name);
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        if (target instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)target;
            return ((Player)playerpatch.getOriginal()).m_7755_().getString().equals(this.name);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        ResizableEditBox editbox = new ResizableEditBox(screen.getMinecraft().f_91062_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"name"), null, null);
        return List.of(Condition.ParameterEditor.of(name -> StringTag.m_129297_((String)name.toString()), tag -> ParseUtil.nullOrToString(tag, Tag::m_7916_), (AbstractWidget)editbox));
    }
}

