/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.PackEntry;
import yesman.epicfight.client.gui.datapack.screen.SelectModelScreen;
import yesman.epicfight.client.gui.datapack.widgets.Grid;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.gameasset.Armatures;

@OnlyIn(value=Dist.CLIENT)
public class ImportModelScreen
extends Screen {
    private final SelectModelScreen caller;
    private final Grid meshGrid;
    private final Grid armatureGrid;
    private final ModelPreviewer modelPreviewer;
    private List<PackEntry<String, AnimatedMesh>> userMeshes = new ArrayList<PackEntry>(DatapackEditScreen.getCurrentScreen().getUserMeshes().entrySet().stream().map(entry -> PackEntry.ofValue(((ResourceLocation)entry.getKey()).toString(), (AnimatedMesh)entry.getValue())).toList());
    private List<PackEntry<String, Armature>> userArmatures = new ArrayList<PackEntry>(DatapackEditScreen.getCurrentScreen().getUserArmatures().entrySet().stream().map(entry -> PackEntry.ofValue(((ResourceLocation)entry.getKey()).toString(), (Armature)entry.getValue())).toList());

    public ImportModelScreen(SelectModelScreen caller) {
        super((Component)Component.m_237113_((String)"register_model_screen"));
        this.caller = caller;
        this.modelPreviewer = new ModelPreviewer(0, 10, 30, 30, ResizableComponent.HorizontalSizing.LEFT_RIGHT, ResizableComponent.VerticalSizing.TOP_BOTTOM, null, null);
        this.f_96541_ = caller.getMinecraft();
        this.f_96547_ = caller.getMinecraft().f_91062_;
        ScreenRectangle screenRect = caller.m_264198_();
        int split = screenRect.f_263770_() / 2 - 60;
        this.meshGrid = Grid.builder(this, caller.getMinecraft()).xy1(8, screenRect.m_274449_() + 14).xy2(split - 10, screenRect.f_263800_() - 21).rowHeight(26).rowEditable(Grid.GridBuilder.RowEditButton.REMOVE).transparentBackground(true).rowpositionChanged((rowposition, values) -> this.modelPreviewer.setMesh(() -> this.userMeshes.get((int)rowposition).getValue())).addColumn(Grid.editbox("mesh_name").editWidgetCreated(editbox -> editbox.m_94153_(ResourceLocation::m_135830_)).valueChanged(event -> this.userMeshes.get(event.rowposition).setPackKey((String)event.postValue)).editable(true).width(180)).pressRemove((grid, button) -> grid.removeRow(rowposition -> this.userMeshes.remove(rowposition))).build();
        this.armatureGrid = Grid.builder(this, caller.getMinecraft()).xy1(8, screenRect.m_274449_() + 14).xy2(split - 10, screenRect.f_263800_() - 21).rowHeight(26).rowEditable(Grid.GridBuilder.RowEditButton.REMOVE).transparentBackground(true).addColumn(Grid.editbox("armature_name").editWidgetCreated(editbox -> editbox.m_94153_(ResourceLocation::m_135830_)).valueChanged(event -> this.userArmatures.get(event.rowposition).setPackKey((String)event.postValue)).editable(true).width(180)).pressRemove((grid, button) -> grid.removeRow(rowposition -> this.userArmatures.remove(rowposition))).build();
        for (PackEntry<String, AnimatedMesh> packEntry : this.userMeshes) {
            this.meshGrid.addRowWithDefaultValues("mesh_name", packEntry.getKey());
        }
        for (PackEntry<String, Object> packEntry : this.userArmatures) {
            this.armatureGrid.addRowWithDefaultValues("armature_name", packEntry.getKey());
        }
    }

    protected void m_7856_() {
        ScreenRectangle screenRect = this.m_264198_();
        int widthSplit = screenRect.f_263770_() / 2 - 20;
        int heightSplit = screenRect.f_263800_() / 2;
        this.meshGrid.m_93437_(widthSplit - 10, heightSplit - 20, screenRect.m_274449_() + 30, heightSplit - 10);
        this.meshGrid.m_93507_(10);
        this.meshGrid.resize(screenRect);
        this.armatureGrid.m_93437_(widthSplit - 10, heightSplit - 18, heightSplit + 8, screenRect.m_274349_() - 30);
        this.armatureGrid.m_93507_(10);
        this.armatureGrid.resize(screenRect);
        this.m_142416_(new Static(this, 10, 100, 14, 15, null, null, (Component)Component.m_237115_((String)"datapack_edit.import_model.meshes"), (Component)Component.m_237113_((String)"")));
        this.m_142416_(this.meshGrid);
        this.m_142416_(new Static(this, 10, 100, heightSplit - 8, 15, null, null, (Component)Component.m_237115_((String)"datapack_edit.import_model.armatures"), (Component)Component.m_237113_((String)"")));
        this.m_142416_(this.armatureGrid);
        this.modelPreviewer.setX1(widthSplit + 10);
        this.modelPreviewer.resize(screenRect);
        this.m_142416_(this.modelPreviewer);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_286989_, button -> {
            Map<ResourceLocation, AnimatedMesh> userMeshes = DatapackEditScreen.getCurrentScreen().getUserMeshes();
            Map<ResourceLocation, Armature> userArmatures = DatapackEditScreen.getCurrentScreen().getUserArmatures();
            userMeshes.clear();
            userArmatures.clear();
            this.userMeshes.forEach(packEntry -> userMeshes.put(new ResourceLocation((String)packEntry.getKey()), (AnimatedMesh)packEntry.getValue()));
            this.userArmatures.forEach(packEntry -> userArmatures.put(new ResourceLocation((String)packEntry.getKey()), (Armature)packEntry.getValue()));
            Meshes.build(Minecraft.m_91087_().m_91098_());
            Armatures.build(Minecraft.m_91087_().m_91098_());
            userMeshes.forEach(Meshes::addMesh);
            userArmatures.forEach(Armatures::addArmature);
            this.m_7379_();
        }).m_252794_(this.f_96543_ / 2 - 162, this.f_96544_ - 26).m_253046_(160, 21).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(new MessageScreen("", "Do you want to quit without saving changes?", this, button2 -> this.m_7379_(), button2 -> this.f_96541_.m_91152_((Screen)this), 180, 70))).m_252794_(this.f_96543_ / 2 + 2, this.f_96544_ - 26).m_253046_(160, 21).m_253136_());
    }

    public void m_86600_() {
        this.meshGrid._tick();
        this.armatureGrid._tick();
    }

    public void m_7379_() {
        this.caller.refreshModelList();
        this.f_96541_.m_91152_((Screen)this.caller);
        this.modelPreviewer.onDestroy();
    }

    public void m_7400_(List<Path> paths) {
        this.f_96541_.m_91152_(new MessageScreen<String>("", "Enter the mod id", this, modid -> {
            this.meshGrid.setValueChangeEnabled(false);
            this.armatureGrid.setValueChangeEnabled(false);
            for (Path path : paths) {
                InputStream stream = null;
                try {
                    File file = path.toFile();
                    stream = new FileInputStream(file);
                    String modelPath = modid + ":" + file.getName().replace(".json", "");
                    JsonModelLoader jsonLoader = new JsonModelLoader(stream, new ResourceLocation(modelPath));
                    AnimatedMesh mesh = jsonLoader.loadAnimatedMesh(AnimatedMesh::new);
                    Armature armature = jsonLoader.loadArmature(Armature::new);
                    this.userMeshes.add(PackEntry.ofValue(modelPath, mesh));
                    this.userArmatures.add(PackEntry.ofValue(modelPath, armature));
                    this.meshGrid.addRowWithDefaultValues("mesh_name", modelPath);
                    this.armatureGrid.addRowWithDefaultValues("armature_name", modelPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.meshGrid.setValueChangeEnabled(true);
            this.armatureGrid.setValueChangeEnabled(true);
            this.f_96541_.m_91152_((Screen)this);
        }, button -> this.f_96541_.m_91152_((Screen)this), new ResizableEditBox(this.f_96541_.f_91062_, 0, 0, 0, 16, (Component)Component.m_237113_((String)"datapack_edit.import_animation.input"), null, null), 120, 80));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.modelPreviewer.m_7979_(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

