/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillExecuteEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@OnlyIn(value=Dist.CLIENT)
public class ControllEngine {
    private final Set<Object> packets = Sets.newHashSet();
    private final Minecraft minecraft;
    private LocalPlayer player;
    private LocalPlayerPatch playerpatch;
    private int weaponInnatePressCounter = 0;
    private int sneakPressCounter = 0;
    private int moverPressCounter = 0;
    private int lastHotbarLockedTime;
    private boolean weaponInnatePressToggle = false;
    private boolean sneakPressToggle = false;
    private boolean moverPressToggle = false;
    private boolean attackLightPressToggle = false;
    private boolean hotbarLocked;
    private boolean chargeKeyUnpressed;
    private int reserveCounter;
    private KeyMapping reservedKey;
    private SkillSlot reservedOrChargingSkillSlot;
    private KeyMapping currentChargingKey;
    public Options options;

    public ControllEngine() {
        Events.controllEngine = this;
        this.minecraft = Minecraft.m_91087_();
        this.options = this.minecraft.f_91066_;
    }

    public void setPlayerPatch(LocalPlayerPatch playerpatch) {
        this.weaponInnatePressCounter = 0;
        this.weaponInnatePressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.attackLightPressToggle = false;
        this.player = (LocalPlayer)playerpatch.getOriginal();
        this.playerpatch = playerpatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerpatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.m_245714_() != null;
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.m_245714_() != null;
    }

    public void handleEpicFightKeyMappings() {
        if (ControllEngine.keyPressed(EpicFightKeyMappings.SKILL_EDIT, false) && this.playerpatch.getSkillCapability() != null) {
            Minecraft.m_91087_().m_91152_((Screen)new SkillEditScreen((Player)this.player, this.playerpatch.getSkillCapability()));
        }
        if (ControllEngine.keyPressed(EpicFightKeyMappings.CONFIG, false)) {
            Minecraft.m_91087_().m_91152_((Screen)new IngameConfigurationScreen(this.minecraft, null));
        }
        while (ControllEngine.keyPressed(EpicFightKeyMappings.ATTACK, true)) {
            if (!this.playerpatch.isBattleMode() || this.currentChargingKey == EpicFightKeyMappings.ATTACK) continue;
            if (!EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) {
                SkillSlots slot;
                SkillSlots skillSlots = slot = !this.player.m_20096_() && !this.player.m_20069_() && this.player.m_20184_().f_82480_ > 0.05 ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
                if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                    this.player.m_36334_();
                    this.attackLightPressToggle = false;
                    this.releaseAllServedKeys();
                } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                    this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
                }
                this.lockHotkeys();
                this.attackLightPressToggle = false;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (!this.weaponInnatePressToggle) {
                this.weaponInnatePressToggle = true;
            }
            if (this.options.f_92096_.getKey() != EpicFightKeyMappings.ATTACK.getKey()) continue;
            ControllEngine.disableKey(this.options.f_92096_);
        }
        while (ControllEngine.keyPressed(EpicFightKeyMappings.DODGE, true)) {
            if (!this.playerpatch.isBattleMode() || this.currentChargingKey == EpicFightKeyMappings.DODGE) continue;
            if (EpicFightKeyMappings.DODGE.getKey().m_84873_() == this.options.f_92090_.getKey().m_84873_()) {
                if (this.player.m_20202_() != null || this.sneakPressToggle) continue;
                this.sneakPressToggle = true;
                continue;
            }
            SkillSlots skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
            SkillContainer skill = this.playerpatch.getSkill(skillCategory);
            if (!skill.sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) continue;
            this.reserveKey(SkillSlots.DODGE, EpicFightKeyMappings.DODGE);
        }
        while (ControllEngine.keyPressed(EpicFightKeyMappings.GUARD, true)) {
        }
        while (ControllEngine.keyPressed(EpicFightKeyMappings.WEAPON_INNATE_SKILL, true)) {
            if (!this.playerpatch.isBattleMode() || this.currentChargingKey == EpicFightKeyMappings.WEAPON_INNATE_SKILL || EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) continue;
            if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                if (this.player.m_5833_()) continue;
                this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                continue;
            }
            this.lockHotkeys();
        }
        while (ControllEngine.keyPressed(EpicFightKeyMappings.MOVER_SKILL, true)) {
            if (!this.playerpatch.isBattleMode() || this.playerpatch.isChargingSkill()) continue;
            if (EpicFightKeyMappings.MOVER_SKILL.getKey().m_84873_() == this.options.f_92089_.getKey().m_84873_()) {
                SkillExecuteEvent event;
                SkillContainer skillContainer = this.playerpatch.getSkill(SkillSlots.MOVER);
                if (!skillContainer.canExecute(this.playerpatch, event = new SkillExecuteEvent(this.playerpatch, skillContainer)) || this.player.m_20202_() != null || this.moverPressToggle) continue;
                this.moverPressToggle = true;
                continue;
            }
            SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
            skill.sendExecuteRequest(this.playerpatch, this);
        }
        while (ControllEngine.keyPressed(EpicFightKeyMappings.SWITCH_MODE, false)) {
            if (!((LocalPlayer)this.playerpatch.getOriginal()).m_9236_().m_46469_().m_46207_(EpicFightGamerules.CAN_SWITCH_COMBAT)) continue;
            this.playerpatch.toggleMode();
        }
        while (ControllEngine.keyPressed(EpicFightKeyMappings.LOCK_ON, false)) {
            this.playerpatch.toggleLockOn();
        }
        if (this.playerpatch.getEntityState().inaction() || !this.playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand()) {
            ControllEngine.disableKey(this.minecraft.f_91066_.f_92093_);
        }
        this.tick();
    }

    private void tick() {
        SkillContainer skill;
        if (this.playerpatch == null || !this.playerpatch.isBattleMode() || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (this.player.f_19797_ - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.weaponInnatePressToggle) {
            if (!ControllEngine.isKeyDown(EpicFightKeyMappings.WEAPON_INNATE_SKILL)) {
                this.attackLightPressToggle = true;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey().equals((Object)EpicFightKeyMappings.ATTACK.getKey())) {
                if (this.weaponInnatePressCounter > (Integer)EpicFightMod.CLIENT_CONFIGS.longPressCount.getValue()) {
                    if (this.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && this.playerpatch.getTarget() == null && !((Boolean)EpicFightMod.CLIENT_CONFIGS.noMiningInCombat.getValue()).booleanValue()) {
                        this.minecraft.m_202354_();
                        ControllEngine.setKeyBind(EpicFightKeyMappings.ATTACK, true);
                    } else if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                        if (!this.player.m_5833_()) {
                            this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.weaponInnatePressToggle = false;
                    this.weaponInnatePressCounter = 0;
                } else {
                    ++this.weaponInnatePressCounter;
                }
            }
        }
        if (this.attackLightPressToggle) {
            SkillSlots slot;
            SkillSlots skillSlots = slot = !this.player.m_20096_() && !this.player.m_20069_() && this.player.m_20184_().f_82480_ > 0.05 ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
            if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                this.player.m_36334_();
                this.releaseAllServedKeys();
            } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
            }
            this.lockHotkeys();
            this.attackLightPressToggle = false;
            this.weaponInnatePressToggle = false;
            this.weaponInnatePressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!ControllEngine.isKeyDown(this.options.f_92090_)) {
                SkillSlots skillSlot = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                SkillContainer skill2 = this.playerpatch.getSkill(skillSlot);
                if (skill2.sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                    this.reserveKey(skillSlot, this.options.f_92090_);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > (Integer)EpicFightMod.CLIENT_CONFIGS.longPressCount.getValue()) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.currentChargingKey != null) {
            skill = this.playerpatch.getSkill(this.reservedOrChargingSkillSlot);
            Skill skill3 = skill.getSkill();
            if (skill3 instanceof ChargeableSkill) {
                ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill3);
                if (!ControllEngine.isKeyDown(this.currentChargingKey)) {
                    this.chargeKeyUnpressed = true;
                }
                if (this.chargeKeyUnpressed && this.playerpatch.getSkillChargingTicks() > chargingSkill.getMinChargingTicks()) {
                    if (skill.getSkill() != null) {
                        skill.sendExecuteRequest(this.playerpatch, this);
                    }
                    this.releaseAllServedKeys();
                }
                if (this.playerpatch.getSkillChargingTicks() >= chargingSkill.getAllowedMaxChargingTicks()) {
                    this.releaseAllServedKeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.reservedKey != null) {
            if (this.reserveCounter > 0) {
                skill = this.playerpatch.getSkill(this.reservedOrChargingSkillSlot);
                --this.reserveCounter;
                if (skill.getSkill() != null && skill.sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                    this.releaseAllServedKeys();
                    this.lockHotkeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.playerpatch.getEntityState().inaction() || this.hotbarLocked) {
            for (int i = 0; i < 9; ++i) {
                while (this.options.f_92056_[i].m_90859_()) {
                }
            }
            while (this.options.f_92094_.m_90859_()) {
            }
        }
    }

    private void inputTick(Input input) {
        if (this.moverPressToggle) {
            if (!ControllEngine.isKeyDown(this.options.f_92089_)) {
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
                if (this.player.m_20096_()) {
                    input.f_108572_ = true;
                }
            } else if (this.moverPressCounter > (Integer)EpicFightMod.CLIENT_CONFIGS.longPressCount.getValue()) {
                SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
                skill.sendExecuteRequest(this.playerpatch, this);
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
            } else {
                input.f_108572_ = false;
                ++this.moverPressCounter;
            }
        }
        if (!this.canPlayerMove(this.playerpatch.getEntityState())) {
            input.f_108567_ = 0.0f;
            input.f_108566_ = 0.0f;
            input.f_108568_ = false;
            input.f_108569_ = false;
            input.f_108570_ = false;
            input.f_108571_ = false;
            input.f_108572_ = false;
            input.f_108573_ = false;
            this.player.f_108583_ = -1;
            this.player.m_6858_(false);
        }
        if (this.player.m_6084_()) {
            this.playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, new MovementInputEvent(this.playerpatch, input));
        }
    }

    private void reserveKey(SkillSlot slot, KeyMapping keyMapping) {
        this.reservedKey = keyMapping;
        this.reservedOrChargingSkillSlot = slot;
        this.reserveCounter = 8;
    }

    private void releaseAllServedKeys() {
        this.chargeKeyUnpressed = true;
        this.currentChargingKey = null;
        this.reservedOrChargingSkillSlot = null;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void setChargingKey(SkillSlot chargingSkillSlot, KeyMapping keyMapping) {
        this.chargeKeyUnpressed = false;
        this.currentChargingKey = keyMapping;
        this.reservedOrChargingSkillSlot = chargingSkillSlot;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.f_19797_;
        for (int i = 0; i < 9; ++i) {
            while (this.options.f_92056_[i].m_90859_()) {
            }
        }
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    public void addPacketToSend(Object packet) {
        this.packets.add(packet);
    }

    public static boolean isKeyDown(KeyMapping key) {
        if (key.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return key.m_90857_() || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        if (key.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return key.m_90857_() || GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        return false;
    }

    private static boolean keyPressed(KeyMapping key, boolean eventCheck) {
        int mouseButton;
        InputEvent.InteractionKeyMappingTriggered inputEvent;
        boolean consumes = key.m_90859_();
        if (consumes && eventCheck && (inputEvent = ForgeHooksClient.onClickInput((int)(mouseButton = InputConstants.Type.MOUSE == key.getKey().m_84868_() ? key.getKey().m_84873_() : -1), (KeyMapping)key, (InteractionHand)InteractionHand.MAIN_HAND)).isCanceled()) {
            return false;
        }
        return consumes;
    }

    public static void disableKey(KeyMapping keyMapping) {
        while (keyMapping.m_90859_()) {
        }
        ControllEngine.setKeyBind(keyMapping, false);
    }

    public static void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollingEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Events.controllEngine.playerpatch != null && Events.controllEngine.playerpatch.getEntityState().inaction() && Events.controllEngine.minecraft.f_91080_ == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(MovementInputUpdateEvent event) {
            if (Events.controllEngine.playerpatch == null) {
                return;
            }
            controllEngine.inputTick(event.getInput());
        }

        @SubscribeEvent
        public static void clientTickEndEvent(TickEvent.ClientTickEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                for (Object packet : Events.controllEngine.packets) {
                    EpicFightNetworkManager.sendToServer(packet);
                }
                Events.controllEngine.packets.clear();
            }
        }
    }
}

