/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class ValueModifier {
    public static final Codec<ValueModifier> CODECS = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("adder").forGetter(ValueModifier::getAdder), (App)Codec.FLOAT.fieldOf("multiplier").forGetter(ValueModifier::getMultiplier), (App)Codec.FLOAT.fieldOf("setter").forGetter(ValueModifier::getSetter)).apply((Applicative)instance, ValueModifier::new));
    private float adder;
    private float multiplier;
    private float setter = Float.NaN;

    public ValueModifier(float adder, float multiplier, float setter) {
        this.adder = adder;
        this.multiplier = multiplier;
        this.setter = setter;
    }

    public void merge(ValueModifier valueCorrector) {
        this.adder += valueCorrector.adder;
        this.multiplier *= valueCorrector.multiplier;
        this.setter = valueCorrector.setter;
    }

    public void eraseSetter() {
        this.setter = Float.NaN;
    }

    public float getAdder() {
        return this.adder;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public float getSetter() {
        return this.setter;
    }

    public float getTotalValue(float value) {
        return Float.isNaN(this.setter) ? value * this.multiplier + this.adder : this.setter;
    }

    public String toString() {
        return Float.isNaN(this.setter) ? String.format("%.0f%%", Float.valueOf(this.multiplier * 100.0f)) + (this.adder == 0.0f ? "" : String.format(" + %.1f", Float.valueOf(this.adder))) : String.format("%.0f", Float.valueOf(this.setter));
    }

    public static ValueModifier empty() {
        return new ValueModifier(0.0f, 1.0f, Float.NaN);
    }

    public static ValueModifier adder(float arg) {
        return new ValueModifier(arg, 1.0f, Float.NaN);
    }

    public static ValueModifier multiplier(float arg) {
        return new ValueModifier(0.0f, arg, Float.NaN);
    }

    public static ValueModifier setter(float arg) {
        return new ValueModifier(0.0f, 1.0f, arg);
    }
}

