/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.animation;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.ibm.icu.impl.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.client.animation.property.JointMaskReloadListener;
import yesman.epicfight.api.client.animation.property.LayerInfo;
import yesman.epicfight.api.client.animation.property.TrailInfo;

@OnlyIn(value=Dist.CLIENT)
public class ClientAnimationDataReader {
    public static final Deserializer DESERIALIZER = new Deserializer();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ClientAnimationDataReader.class, (Object)DESERIALIZER).create();
    private static final TypeToken<ClientAnimationDataReader> TYPE = new TypeToken<ClientAnimationDataReader>(){};
    private final LayerInfo layerInfo;
    private final LayerInfo multilayerInfo;
    private final List<TrailInfo> trailInfo;

    public static void readAndApply(StaticAnimation animation, Resource iresource) {
        InputStream inputstream = null;
        try {
            inputstream = iresource.m_215507_();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (inputstream != null);
        ClientAnimationDataReader.readAndApply(animation, inputstream);
    }

    public static void readAndApply(StaticAnimation animation, InputStream resourceReader) {
        InputStreamReader reader = new InputStreamReader(resourceReader, StandardCharsets.UTF_8);
        ClientAnimationDataReader propertySetter = (ClientAnimationDataReader)GsonHelper.m_13767_((Gson)GSON, (Reader)reader, TYPE);
        propertySetter.applyClientData(animation);
    }

    public void applyClientData(StaticAnimation animation) {
        if (this.layerInfo != null) {
            if (this.layerInfo.jointMaskEntry.isValid()) {
                animation.addProperty(ClientAnimationProperties.JOINT_MASK, this.layerInfo.jointMaskEntry);
            }
            animation.addProperty(ClientAnimationProperties.LAYER_TYPE, this.layerInfo.layerType);
            animation.addProperty(ClientAnimationProperties.PRIORITY, this.layerInfo.priority);
        }
        if (this.multilayerInfo != null) {
            StaticAnimation multilayerAnimation = new StaticAnimation(animation.getLocation(), animation.getConvertTime(), animation.isRepeat(), animation.getRegistryName().toString() + "_multilayer", animation.getArmature(), true);
            if (this.multilayerInfo.jointMaskEntry.isValid()) {
                multilayerAnimation.addProperty(ClientAnimationProperties.JOINT_MASK, this.multilayerInfo.jointMaskEntry);
            }
            multilayerAnimation.addProperty(ClientAnimationProperties.LAYER_TYPE, this.multilayerInfo.layerType);
            multilayerAnimation.addProperty(ClientAnimationProperties.PRIORITY, this.multilayerInfo.priority);
            multilayerAnimation.addProperty(AnimationProperty.StaticAnimationProperty.ELAPSED_TIME_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
                Layer.BaseLayer baseLayer = entitypatch.getClientAnimator().baseLayer;
                if (baseLayer.animationPlayer.getAnimation().getRealAnimation() != animation) {
                    return Pair.of((Object)Float.valueOf(prevElapsedTime), (Object)Float.valueOf(elapsedTime));
                }
                if (!self.isStaticAnimation() && baseLayer.animationPlayer.getAnimation().isStaticAnimation()) {
                    return Pair.of((Object)Float.valueOf(prevElapsedTime + speed), (Object)Float.valueOf(elapsedTime + speed));
                }
                return Pair.of((Object)Float.valueOf(baseLayer.animationPlayer.getPrevElapsedTime()), (Object)Float.valueOf(baseLayer.animationPlayer.getElapsedTime()));
            });
            animation.addProperty(ClientAnimationProperties.MULTILAYER_ANIMATION, multilayerAnimation);
        }
        if (this.trailInfo.size() > 0) {
            animation.addProperty(ClientAnimationProperties.TRAIL_EFFECT, this.trailInfo);
        }
    }

    private ClientAnimationDataReader(LayerInfo compositeLayerInfo, LayerInfo layerInfo, List<TrailInfo> trailInfo) {
        this.multilayerInfo = compositeLayerInfo;
        this.layerInfo = layerInfo;
        this.trailInfo = trailInfo;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ClientAnimationDataReader> {
        static LayerInfo deserializeLayerInfo(JsonObject jsonObject) {
            return Deserializer.deserializeLayerInfo(jsonObject, null);
        }

        static LayerInfo deserializeLayerInfo(JsonObject jsonObject, Layer.LayerType defaultLayerType) {
            Layer.LayerType layerType;
            JointMaskEntry.Builder builder = JointMaskEntry.builder();
            Layer.Priority priority = jsonObject.has("priority") ? Layer.Priority.valueOf(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"priority")) : null;
            Layer.LayerType layerType2 = layerType = jsonObject.has("layer") ? Layer.LayerType.valueOf(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"layer")) : Layer.LayerType.BASE_LAYER;
            if (jsonObject.has("masks")) {
                builder.defaultMask(JointMaskEntry.ALL);
                JsonArray maskArray = jsonObject.get("masks").getAsJsonArray();
                maskArray.forEach(element -> {
                    JsonObject jointMaskEntry = element.getAsJsonObject();
                    String livingMotionName = GsonHelper.m_13906_((JsonObject)jointMaskEntry, (String)"livingmotion");
                    String type = GsonHelper.m_13906_((JsonObject)jointMaskEntry, (String)"type");
                    if (!type.contains(":")) {
                        type = "epicfight" + ":" + type;
                    }
                    if (livingMotionName.equals("ALL")) {
                        builder.defaultMask(JointMaskReloadListener.getJointMaskEntry(type));
                    } else {
                        builder.mask(LivingMotion.ENUM_MANAGER.getOrThrow(livingMotionName), JointMaskReloadListener.getJointMaskEntry(type));
                    }
                });
            }
            return new LayerInfo(builder.create(), priority, defaultLayerType == null ? layerType : defaultLayerType);
        }

        public ClientAnimationDataReader deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            LayerInfo layerInfo = null;
            LayerInfo multilayerInfo = null;
            if (jsonObject.has("multilayer")) {
                JsonObject multiplayerJson = jsonObject.get("multilayer").getAsJsonObject();
                layerInfo = Deserializer.deserializeLayerInfo(multiplayerJson.get("base").getAsJsonObject());
                multilayerInfo = Deserializer.deserializeLayerInfo(multiplayerJson.get("composite").getAsJsonObject(), Layer.LayerType.COMPOSITE_LAYER);
            } else {
                layerInfo = Deserializer.deserializeLayerInfo(jsonObject);
            }
            ArrayList trailInfos = Lists.newArrayList();
            if (jsonObject.has("trail_effects")) {
                JsonArray trailArray = jsonObject.get("trail_effects").getAsJsonArray();
                trailArray.forEach(element -> trailInfos.add(TrailInfo.deserialize(element)));
            }
            return new ClientAnimationDataReader(multilayerInfo, layerInfo, trailInfos);
        }
    }
}

