/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.ActionEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MainFrameAnimation
extends StaticAnimation {
    public MainFrameAnimation(float convertTime, String path, Armature armature) {
        super(convertTime, false, path, armature);
    }

    public MainFrameAnimation(float convertTime, String path, Armature armature, boolean noRegister) {
        super(convertTime, false, path, armature, noRegister);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.updateEntityState();
        if (entitypatch.isLogicalClient()) {
            entitypatch.getClientAnimator().resetMotion();
            entitypatch.getClientAnimator().resetCompositeMotion();
            entitypatch.getClientAnimator().getPlayerFor(this).setReversed(false);
        }
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            if (playerpatch.isLogicalClient()) {
                if (((Player)playerpatch.getOriginal()).m_7578_()) {
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ACTION_EVENT_CLIENT, new ActionEvent(playerpatch, this));
                }
            } else {
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ACTION_EVENT_SERVER, new ActionEvent(playerpatch, this));
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        ((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267771_(0.0f);
    }

    @Override
    public boolean isMainFrameAnimation() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.HIGHEST);
    }
}

