/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ActionAnimation
extends MainFrameAnimation {
    public ActionAnimation(float convertTime, String path, Armature armature) {
        this(convertTime, Float.MAX_VALUE, path, armature);
    }

    public ActionAnimation(float convertTime, String path, Armature armature, boolean noRegister) {
        this(convertTime, Float.MAX_VALUE, path, armature, noRegister);
    }

    public ActionAnimation(float convertTime, float postDelay, String path, Armature armature) {
        this(convertTime, postDelay, path, armature, false);
    }

    public ActionAnimation(float convertTime, float postDelay, String path, Armature armature, boolean noRegister) {
        super(convertTime, path, armature, noRegister);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, postDelay).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.CAN_BASIC_ATTACK, false).addState(EntityState.CAN_SKILL_EXECUTION, false).newTimePair(0.01f, postDelay).addState(EntityState.TURNING_LOCKED, true).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, true);
        this.addProperty(AnimationProperty.StaticAnimationProperty.FIXED_HEAD_ROTATION, Boolean.valueOf(true));
    }

    public <V> ActionAnimation addProperty(AnimationProperty.ActionAnimationProperty<V> propertyType, V value) {
        this.properties.put(propertyType, value);
        return this;
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.cancelAnyAction();
        if (entitypatch.shouldMoveOnCurrentSide(this)) {
            entitypatch.correctRotation();
            if (this.getProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT).orElse(false).booleanValue()) {
                ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_, 0.0);
                ((LivingEntity)entitypatch.getOriginal()).f_20900_ = 0.0f;
                ((LivingEntity)entitypatch.getOriginal()).f_20901_ = 0.0f;
                ((LivingEntity)entitypatch.getOriginal()).f_20902_ = 0.0f;
            }
            MoveCoordFunctions.MoveCoordSetter moveCoordSetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN).orElse(MoveCoordFunctions.RAW_COORD);
            moveCoordSetter.set(this, entitypatch, entitypatch.getArmature().getActionAnimationCoord());
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        this.move(entitypatch, this);
    }

    @Override
    public void linkTick(LivingEntityPatch<?> entitypatch, DynamicAnimation linkAnimation) {
        this.move(entitypatch, linkAnimation);
    }

    protected void move(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        if (!this.validateMovement(entitypatch, animation)) {
            return;
        }
        if (this.getState(EntityState.INACTION, entitypatch, animation, ((Animator)entitypatch.getAnimator()).getPlayerFor(this).getElapsedTime()).booleanValue()) {
            LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
            Vec3 vec3 = this.getCoordVector(entitypatch, animation);
            livingentity.m_6478_(MoverType.SELF, vec3);
        }
    }

    protected boolean validateMovement(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        if (!entitypatch.shouldMoveOnCurrentSide(this)) {
            return false;
        }
        if (animation.isLinkAnimation()) {
            if (!this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK).orElse(true).booleanValue()) {
                return false;
            }
            return this.shouldMove(0.0f);
        }
        return this.shouldMove(((Animator)entitypatch.getAnimator()).getPlayerFor(animation).getElapsedTime());
    }

    protected boolean shouldMove(float currentTime) {
        if (this.properties.containsKey(AnimationProperty.ActionAnimationProperty.MOVE_TIME)) {
            TimePairList moveTimes = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_TIME).get();
            return moveTimes.isTimeInPairs(currentTime);
        }
        return true;
    }

    @Override
    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        JointTransform jt = pose.getOrDefaultTransform("Root");
        Vec3f jointPosition = jt.translation();
        OpenMatrix4f toRootTransformApplied = entitypatch.getArmature().searchJointByName("Root").getLocalTrasnform().removeTranslation();
        OpenMatrix4f toOrigin = OpenMatrix4f.invert(toRootTransformApplied, null);
        Vec3f worldPosition = OpenMatrix4f.transform3v(toRootTransformApplied, jointPosition, null);
        worldPosition.x = 0.0f;
        worldPosition.y = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false && worldPosition.y > 0.0f ? 0.0f : worldPosition.y;
        worldPosition.z = 0.0f;
        OpenMatrix4f.transform3v(toOrigin, worldPosition, worldPosition);
        jointPosition.x = worldPosition.x;
        jointPosition.y = worldPosition.y;
        jointPosition.z = worldPosition.z;
        super.modifyPose(animation, pose, entitypatch, time, partialTicks);
    }

    @Override
    public void setLinkAnimation(DynamicAnimation fromAnimation, Pose startPose, boolean isOnSameLayer, float convertTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        dest.resetNextStartTime();
        float playTime = this.getPlaySpeed(entitypatch, dest);
        AnimationProperty.PlaybackSpeedModifier playSpeedModifier = this.getRealAnimation().getProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER).orElse(null);
        if (playSpeedModifier != null) {
            playTime = playSpeedModifier.modify(this, entitypatch, playTime, 0.0f, playTime);
        }
        playTime = Math.abs(playTime);
        float linkTime = convertTimeModifier > 0.0f ? convertTimeModifier + this.convertTime : this.convertTime;
        float totalTime = (playTime *= 0.05f) * (float)((int)Math.ceil(linkTime / playTime));
        float nextStartTime = Math.max(0.0f, -convertTimeModifier);
        dest.setNextStartTime(nextStartTime += totalTime - linkTime);
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime + 0.001f);
        dest.setConnectedAnimations(fromAnimation, this);
        Pose nextStartPose = this.getPoseByTime(entitypatch, nextStartTime, 1.0f);
        if (entitypatch.shouldMoveOnCurrentSide(this) && this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK).orElse(true).booleanValue()) {
            this.removeRootTranslation(entitypatch, nextStartPose, nextStartTime);
        }
        Map<String, JointTransform> data1 = startPose.getJointTransformData();
        Map<String, JointTransform> data2 = nextStartPose.getJointTransformData();
        HashSet<String> joint1 = new HashSet<String>(isOnSameLayer ? data1.keySet() : Set.of());
        HashSet<String> joint2 = new HashSet<String>(data2.keySet());
        if (entitypatch.isLogicalClient()) {
            JointMaskEntry entry = fromAnimation.getJointMaskEntry(entitypatch, false).orElse(null);
            JointMaskEntry entry2 = this.getJointMaskEntry(entitypatch, true).orElse(null);
            if (entry != null && entitypatch.isLogicalClient()) {
                joint1.removeIf(jointName -> entry.isMasked(fromAnimation.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getClientAnimator().currentMotion() : entitypatch.getClientAnimator().currentCompositeMotion(), (String)jointName));
            }
            if (entry2 != null && entitypatch.isLogicalClient()) {
                joint2.removeIf(jointName -> entry2.isMasked(this.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getCurrentLivingMotion() : entitypatch.currentCompositeMotion, (String)jointName));
            }
        }
        joint1.addAll(joint2);
        if (linkTime != totalTime) {
            Pose pose = this.getPoseByTime(entitypatch, 0.0f, 0.0f);
            Map<String, JointTransform> poseData = pose.getJointTransformData();
            if (entitypatch.shouldMoveOnCurrentSide(this) && this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK).orElse(true).booleanValue()) {
                this.removeRootTranslation(entitypatch, pose, 0.0f);
            }
            for (String jointName2 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.getOrDefault(jointName2, JointTransform.empty())), new Keyframe(linkTime, poseData.get(jointName2)), new Keyframe(totalTime, data2.get(jointName2))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName2, sheet);
            }
        } else {
            for (String jointName3 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.getOrDefault(jointName3, JointTransform.empty())), new Keyframe(totalTime, data2.get(jointName3))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName3, sheet);
            }
        }
    }

    public void removeRootTranslation(LivingEntityPatch<?> entitypatch, Pose pose, float poseTime) {
        JointTransform jt = pose.getOrDefaultTransform("Root");
        if (this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).isEmpty()) {
            Vec3f withPosition = entitypatch.getArmature().getActionAnimationCoord().getInterpolatedTranslation(poseTime);
            jt.translation().set(withPosition);
        } else {
            TransformSheet coordTransform = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).get();
            Vec3f nextCoord = coordTransform.getKeyframes()[0].transform().translation();
            jt.translation().add(0.0f, 0.0f, nextCoord.z);
        }
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        TransformSheet rootCoord;
        MoveCoordFunctions.MoveCoordSetter moveCoordsetter;
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(animation);
        TimePairList coordUpdateTime = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_UPDATE_TIME).orElse(null);
        boolean isCoordUpdateTime = coordUpdateTime == null || coordUpdateTime.isTimeInPairs(player.getElapsedTime());
        MoveCoordFunctions.MoveCoordSetter moveCoordSetter = moveCoordsetter = isCoordUpdateTime ? (MoveCoordFunctions.MoveCoordSetter)this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK).orElse(null) : MoveCoordFunctions.RAW_COORD;
        if (moveCoordsetter != null) {
            TransformSheet transformSheet = animation.isLinkAnimation() ? animation.getCoord() : entitypatch.getArmature().getActionAnimationCoord();
            moveCoordsetter.set(animation, entitypatch, transformSheet);
        }
        if (animation.isLinkAnimation()) {
            rootCoord = animation.getCoord();
        } else {
            rootCoord = entitypatch.getArmature().getActionAnimationCoord();
            if (rootCoord == null) {
                rootCoord = animation.getCoord();
            }
        }
        boolean hasNoGravity = ((LivingEntity)entitypatch.getOriginal()).m_20068_();
        boolean moveVertical = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).isPresent());
        MoveCoordFunctions.MoveCoordGetter moveGetter = isCoordUpdateTime ? this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_GET).orElse(MoveCoordFunctions.DIFF_FROM_PREV_COORD) : MoveCoordFunctions.DIFF_FROM_PREV_COORD;
        Vec3f move = moveGetter.get(animation, entitypatch, rootCoord);
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        Vec3 motion = livingentity.m_20184_();
        this.getProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME).ifPresentOrElse(noGravityTime -> {
            if (noGravityTime.isTimeInPairs(animation.isLinkAnimation() ? 0.0f : player.getElapsedTime())) {
                livingentity.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
            } else {
                move.y = 0.0f;
            }
        }, () -> {
            if (moveVertical && move.y > 0.0f && !hasNoGravity) {
                double gravity = livingentity.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_();
                livingentity.m_20334_(motion.f_82479_, motion.f_82480_ <= 0.0 ? motion.f_82480_ + gravity : motion.f_82480_, motion.f_82481_);
            }
        });
        return move.toDoubleVector();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldPlayerMove(LocalPlayerPatch playerpatch) {
        return playerpatch.isLogicalClient();
    }
}

