/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.damagesource;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;

public class ExtraDamageInstance {
    public static final ExtraDamage TARGET_LOST_HEALTH = new ExtraDamage((attacker, itemstack, target, baseDamage, params) -> (target.m_21233_() - target.m_21223_()) * params[0], (itemstack, tooltips, baseDamage, params) -> tooltips.m_7220_((Component)Component.m_237110_((String)"damage_source.epicfight.target_lost_health", (Object[])new Object[]{Component.m_237113_((String)(ItemStack.f_41584_.format(params[0] * 100.0f) + "%")).m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_GRAY)));
    public static final ExtraDamage SWEEPING_EDGE_ENCHANTMENT = new ExtraDamage((attacker, itemstack, target, baseDamage, params) -> {
        int i = itemstack.getEnchantmentLevel(Enchantments.f_44983_);
        float modifier = i > 0 ? (float)i / ((float)i + 1.0f) : 0.0f;
        return baseDamage * modifier;
    }, (itemstack, tooltips, baseDamage, params) -> {
        int i = itemstack.getEnchantmentLevel(Enchantments.f_44983_);
        if (i > 0) {
            double modifier = (double)i / ((double)i + 1.0);
            double damage = baseDamage * modifier;
            tooltips.m_7220_((Component)Component.m_237110_((String)"damage.epicfight.sweeping_edge_enchant_level", (Object[])new Object[]{Component.m_237113_((String)ItemStack.f_41584_.format(damage)).m_130940_(ChatFormatting.DARK_PURPLE), i}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    });
    private final ExtraDamage calculator;
    private final float[] params;

    public ExtraDamageInstance(ExtraDamage calculator, float ... params) {
        this.calculator = calculator;
        this.params = params;
    }

    public float[] getParams() {
        return this.params;
    }

    public Object[] toTransableComponentParams() {
        Object[] params = new Object[this.params.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = Component.m_237113_((String)(ItemStack.f_41584_.format(this.params[i] * 100.0f) + "%")).m_130940_(ChatFormatting.RED);
        }
        return params;
    }

    public float get(LivingEntity attacker, ItemStack hurtItem, LivingEntity target, float baseDamage) {
        return this.calculator.extraDamage.getBonusDamage(attacker, hurtItem, target, baseDamage, this.params);
    }

    public void setTooltips(ItemStack itemstack, MutableComponent tooltip, double baseDamage) {
        this.calculator.tooltip.setTooltip(itemstack, tooltip, baseDamage, this.params);
    }

    public static class ExtraDamage {
        ExtraDamageFunction extraDamage;
        ExtraDamageTooltipFunction tooltip;

        public ExtraDamage(ExtraDamageFunction extraDamage, ExtraDamageTooltipFunction tooltip) {
            this.extraDamage = extraDamage;
            this.tooltip = tooltip;
        }

        public ExtraDamageInstance create(float ... params) {
            return new ExtraDamageInstance(this, params);
        }
    }

    @FunctionalInterface
    public static interface ExtraDamageFunction {
        public float getBonusDamage(LivingEntity var1, ItemStack var2, LivingEntity var3, float var4, float[] var5);
    }

    @FunctionalInterface
    public static interface ExtraDamageTooltipFunction {
        public void setTooltip(ItemStack var1, MutableComponent var2, double var3, float[] var5);
    }
}

