/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.AttackAnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class SimpleWeaponInnateSkill
extends WeaponInnateSkill {
    protected AttackAnimationProvider attackAnimation;

    public static Builder createSimpleWeaponInnateBuilder() {
        return new Builder().setCategory(SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.WEAPON_CHARGE);
    }

    public SimpleWeaponInnateSkill(Builder builder) {
        super(builder);
        this.attackAnimation = builder.attackAnimation;
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        executer.playAnimationSynchronized(this.attackAnimation.get(), 0.0f);
        super.executeOnServer(executer, args);
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        AttackAnimation anim = this.attackAnimation.get();
        for (AttackAnimation.Phase phase : anim.phases) {
            phase.addProperties(((Map)this.properties.get(0)).entrySet());
        }
        return this;
    }

    public static class Builder
    extends Skill.Builder<SimpleWeaponInnateSkill> {
        protected AttackAnimationProvider attackAnimation;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setAnimations(AttackAnimationProvider attackAnimation) {
            this.attackAnimation = attackAnimation;
            return this;
        }
    }
}

