/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SwordmasterSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a395b692-fd97-11eb-9a03-0242ac130003");
    private static final CapabilityItem.WeaponCategories[] AVAILABLE_WEAPON_TYPES = new CapabilityItem.WeaponCategories[]{CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI};
    private float speedBonus;

    public SwordmasterSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.speedBonus = parameters.m_128457_("speed_bonus");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            WeaponCategory heldWeaponCategory = event.getItemCapability().getWeaponCategory();
            for (CapabilityItem.WeaponCategories weaponCategory : AVAILABLE_WEAPON_TYPES) {
                if (weaponCategory != heldWeaponCategory) continue;
                float attackSpeed = event.getAttackSpeed();
                event.setAttackSpeed(attackSpeed * (1.0f + this.speedBonus * 0.01f));
                break;
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.0f", Float.valueOf(this.speedBonus)));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < AVAILABLE_WEAPON_TYPES.length; ++i) {
            sb.append(WeaponCategory.ENUM_MANAGER.toTranslated(AVAILABLE_WEAPON_TYPES[i]));
            if (i >= AVAILABLE_WEAPON_TYPES.length - 1) continue;
            sb.append(", ");
        }
        list.add(sb.toString());
        return list;
    }

    @Override
    public List<WeaponCategory> getAvailableWeaponCategories() {
        return List.of(AVAILABLE_WEAPON_TYPES);
    }
}

