/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class StaminaPillagerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("20807880-fd30-11eb-9a03-0242ac130003");
    protected float regenRate;

    public StaminaPillagerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.regenRate = parameters.m_128457_("regen_rate");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            if (event.getAttackDamage() > event.getTarget().m_21223_()) {
                float stamina = ((ServerPlayerPatch)event.getPlayerPatch()).getStamina();
                float missingStamina = ((ServerPlayerPatch)event.getPlayerPatch()).getMaxStamina() - stamina;
                ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(stamina + missingStamina * this.regenRate * 0.01f);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.0f", Float.valueOf(this.regenRate)));
        return list;
    }
}

