/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EnduranceSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("12ce9f7a-0457-11ee-be56-0242ac120002");
    private float staminaRatio;

    public EnduranceSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.staminaRatio = parameters.m_128457_("stamina_ratio");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (container.getStack() > 0 && container.getExecuter().getEntityState().getLevel() == 1 && !container.getExecuter().isLogicalClient()) {
                float staminaConsume = Math.max(container.getExecuter().getStamina() * this.staminaRatio, 1.5f);
                if (container.getExecuter().consumeForSkill(this, Skill.Resource.STAMINA, staminaConsume)) {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                    buf.writeFloat(staminaConsume);
                    this.executeOnServer((ServerPlayerPatch)container.getExecuter(), buf);
                }
            }
        });
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnServer(executer, args);
        float staminaConsume = args.readFloat();
        executer.setMaxStunShield(staminaConsume);
        executer.setStunShield(staminaConsume);
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
    }

    @Override
    public void cancelOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        executer.setStunShield(0.0f);
        executer.setMaxStunShield(0.0f);
        super.cancelOnServer(executer, args);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return container.getStack() == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%d", this.maxDuration / 20));
        return list;
    }

    @Override
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.cooldown.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.cooldown.consume", (Object[])new Object[]{ItemStack.f_41584_.format(this.getConsumption())}), SkillBookScreen.COOLDOWN_TEXTURE_INFO);
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.stamina_current_ratio.consume", (Object[])new Object[]{ItemStack.f_41584_.format(this.staminaRatio * 100.0f)}), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }
}

