/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.guard;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;

public class ImpactGuardSkill
extends GuardSkill {
    protected float superiorPenalizer;
    protected float damageReducer;

    public static GuardSkill.Builder createEnergizingGuardBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.TWO_HAND ? Animations.SPEAR_GUARD_HIT : null).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_HIT);
    }

    public ImpactGuardSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.superiorPenalizer = parameters.m_128457_("superior_penalizer");
        this.damageReducer = parameters.m_128457_("damage_reducer");
    }

    @Override
    public void guard(SkillContainer container, CapabilityItem itemCapapbility, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        boolean canUse = this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapapbility, GuardSkill.BlockType.ADVANCED_GUARD);
        if (((DamageSource)event.getDamageSource()).m_269533_(DamageTypeTags.f_268415_)) {
            impact = event.getAmount();
        }
        super.guard(container, itemCapapbility, event, knockback, impact, canUse);
    }

    @Override
    public void dealEvent(PlayerPatch<?> playerpatch, HurtEvent.Pre event, boolean advanced) {
        Object t;
        boolean isSpecialSource = ImpactGuardSkill.isAdvancedBlockableDamageSource((DamageSource)event.getDamageSource());
        event.setAmount(isSpecialSource ? event.getAmount() * this.damageReducer * 0.01f : 0.0f);
        event.setResult(isSpecialSource ? AttackResult.ResultType.SUCCESS : AttackResult.ResultType.BLOCKED);
        LivingEntityPatch attackerpatch = EpicFightCapabilities.getEntityPatch(((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class);
        if (attackerpatch != null) {
            attackerpatch.setLastAttackEntity((Entity)playerpatch.getOriginal());
        }
        if ((t = event.getDamageSource()) instanceof EpicFightDamageSource) {
            EpicFightDamageSource epicfightDamageSource = (EpicFightDamageSource)((Object)t);
            epicfightDamageSource.setStunType(StunType.NONE);
        }
        event.setCanceled(true);
        Entity directEntity = ((DamageSource)event.getDamageSource()).m_7640_();
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(directEntity, LivingEntityPatch.class);
        if (advanced) {
            LivingEntity original = (LivingEntity)playerpatch.getOriginal();
            ((HitParticleType)((Object)EpicFightParticles.AIR_BURST.get())).spawnParticleWithArgument((ServerLevel)original.m_9236_(), null, null, (Entity)original, directEntity);
        }
        if (entitypatch != null) {
            entitypatch.onAttackBlocked((DamageSource)event.getDamageSource(), playerpatch);
        }
    }

    @Override
    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(EpicFightDamageType.PARTIAL_DAMAGE) && (!damageSource.m_269533_(DamageTypeTags.f_268490_) && !damageSource.m_269533_(DamageTypeTags.f_268524_) && !damageSource.m_269533_(DamageTypeTags.f_268415_) && !damageSource.m_276093_(DamageTypes.f_268515_) && !damageSource.m_269533_(DamageTypeTags.f_268745_) || advanced);
    }

    @Override
    public float getPenalizer(CapabilityItem itemCap) {
        return this.advancedGuardMotions.containsKey(itemCap.getWeaponCategory()) ? this.superiorPenalizer : this.penalizer;
    }

    private static boolean isAdvancedBlockableDamageSource(DamageSource damageSource) {
        return damageSource.m_269533_(DamageTypeTags.f_268415_) || damageSource.m_276093_(DamageTypes.f_268515_) || damageSource.m_269533_(DamageTypeTags.f_268745_) || damageSource.m_269533_(DamageTypeTags.f_268524_) || damageSource.m_269533_(DamageTypeTags.f_268490_);
    }

    @Override
    public Skill getPriorSkill() {
        return EpicFightSkills.GUARD;
    }

    @Override
    protected boolean isAdvancedGuard() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.1f", Float.valueOf(100.0f - this.damageReducer)));
        return list;
    }

    @Override
    public List<WeaponCategory> getAvailableWeaponCategories() {
        return List.copyOf(this.advancedGuardMotions.keySet());
    }
}

